/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.tools;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.IHost;
import com.fusesource.ide.jvmmonitor.core.IJvmAttachHandler;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.tools.IConstants;
import com.fusesource.ide.jvmmonitor.internal.tools.Messages;
import com.fusesource.ide.jvmmonitor.internal.tools.Tools;
import com.fusesource.ide.jvmmonitor.tools.Activator;
import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;

public class JvmAttachHandler
implements IJvmAttachHandler,
IPropertyChangeListener,
IConstants {
    private IHost localhost;
    Timer timer;

    public void setHost(IHost host) {
        this.localhost = host;
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.startMonitoring();
    }

    public boolean hasValidJdk() {
        return Tools.getInstance().isReady();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.startMonitoring();
    }

    private void startMonitoring() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    JvmAttachHandler.this.updatesActiveJvms();
                }
                catch (Throwable t) {
                    Activator.log(4, Messages.updateTimerCanceledMsg, t);
                    JvmAttachHandler.this.timer.cancel();
                }
            }
        };
        long period = Activator.getDefault().getPreferenceStore().getLong("com.fusesource.ide.jvmmonitor.tools.updatePeriod");
        this.timer.schedule(timerTask, 0L, period);
    }

    void updatesActiveJvms() throws JvmCoreException {
        Object monitoredHost = Tools.getInstance().invokeGetMonitoredHost("localhost");
        Set<Integer> activeJvms = Tools.getInstance().invokeActiveVms(monitoredHost);
        List previousVms = this.localhost.getActiveJvms();
        for (int pid : activeJvms) {
            if (this.containJvm(previousVms, pid)) continue;
            this.addActiveJvm(pid, monitoredHost);
        }
        for (IActiveJvm jvm : previousVms) {
            Integer pid = jvm.getPid();
            if (activeJvms.contains(pid)) continue;
            this.localhost.removeJvm(pid.intValue());
        }
    }

    private boolean containJvm(List<IActiveJvm> jvms, int pid) {
        for (IActiveJvm jvm : jvms) {
            if (jvm.getPid() != pid) continue;
            return true;
        }
        return false;
    }

    private void addActiveJvm(int pid, Object monitoredHost) {
        String message;
        String vmId = String.format("//%d?mode=r", pid);
        Tools tools = Tools.getInstance();
        Object monitoredVm = null;
        try {
            monitoredVm = tools.invokeGetMonitoredVm(monitoredHost, tools.invokeVmIdentifier(vmId));
        }
        catch (JvmCoreException e) {
            Activator.log(4, Messages.getMonitoredJvmFailedMsg, e);
        }
        String mainClass = null;
        String localConnectorAddress = null;
        String stateMessage = null;
        if (monitoredVm != null) {
            mainClass = this.getMainClass(monitoredVm, pid);
            try {
                localConnectorAddress = this.getLocalConnectorAddress(monitoredVm, pid);
            }
            catch (JvmCoreException e) {
                stateMessage = e.getMessage();
                message = NLS.bind((String)Messages.getLocalConnectorAddressFailedMsg, (Object)pid);
                Activator.log(2, message, e);
            }
        }
        try {
            this.localhost.addLocalActiveJvm(pid, mainClass, localConnectorAddress, stateMessage);
        }
        catch (JvmCoreException e) {
            message = NLS.bind((String)Messages.connectTargetJvmFailedMsg, (Object)pid);
            Activator.log(2, message, e);
        }
    }

    private String getMainClass(Object monitoredVm, int pid) {
        Object monitor;
        Tools tools;
        block4: {
            try {
                tools = Tools.getInstance();
                monitor = tools.invokeFindByName(monitoredVm, "sun.rt.javaCommand");
                if (monitor != null) break block4;
                return "";
            }
            catch (JvmCoreException e) {
                String message = NLS.bind((String)Messages.getMainClassNameFailed, (Object)pid);
                Activator.log(4, message, e);
                return "";
            }
        }
        String javaCommand = tools.invokeGetValue(monitor).toString();
        if (javaCommand == null) {
            return "";
        }
        String[] elements = javaCommand.split(" -");
        String mainClass = elements.length > 0 ? elements[0] : javaCommand;
        return mainClass;
    }

    private String getLocalConnectorAddress(Object monitoredVm, int pid) throws JvmCoreException {
        String url = null;
        Tools tools = Tools.getInstance();
        Object virtualMachine = null;
        try {
            virtualMachine = tools.invokeAttach(pid);
            String javaHome = ((Properties)tools.invokeGetSystemProperties(virtualMachine)).getProperty("java.home");
            File file = new File(String.valueOf(javaHome) + IConstants.MANAGEMENT_AGENT_JAR);
            if (!file.exists()) {
                String message = NLS.bind((String)Messages.fileNotFoundMsg, (Object)file.getPath());
                throw new JvmCoreException(4, message, (Throwable)new Exception());
            }
            tools.invokeLoadAgent(virtualMachine, file.getAbsolutePath(), "com.sun.management.jmxremote");
            Properties props = tools.invokeGetAgentProperties(virtualMachine);
            url = (String)props.get("com.sun.management.jmxremote.localConnectorAddress");
        }
        catch (Throwable throwable) {
            if (virtualMachine != null) {
                try {
                    tools.invokeDetach(virtualMachine);
                }
                catch (JvmCoreException jvmCoreException) {}
            }
            throw throwable;
        }
        if (virtualMachine != null) {
            try {
                tools.invokeDetach(virtualMachine);
            }
            catch (JvmCoreException jvmCoreException) {}
        }
        return url;
    }
}

