/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.tools;

import com.fusesource.ide.jvmmonitor.internal.tools.IConstants;
import com.fusesource.ide.jvmmonitor.internal.tools.Messages;
import com.fusesource.ide.jvmmonitor.internal.tools.Tools;
import com.fusesource.ide.jvmmonitor.tools.Activator;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ToolsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IConstants {
    private static final String JAVA_MONITOR_TOOLS_PREFERENCE_PAGE = "com.fusesource.ide.jvmmonitor.tools.java_monitor_tools_preference_page_context";
    private static final int MIN_UPDATE_PERIOD = 100;
    Text jdkRootDirectoryText;
    private Text updatePeriodText;
    private Text maxNumberOfClassesText;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        if (!Util.isMac()) {
            Label label = new Label(composite, 64);
            label.setText(Messages.toolsPreferencePageLabel);
            GridData layoutData = new GridData(768);
            layoutData.widthHint = 300;
            label.setLayoutData((Object)layoutData);
            this.createJdkRootDirectoryGroup(composite);
        }
        this.createUpdatePeriodTextField(composite);
        this.createMemoryGroup(composite);
        this.applyDialogFont(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, JAVA_MONITOR_TOOLS_PREFERENCE_PAGE);
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            if (this.jdkRootDirectoryText == null) {
                return true;
            }
            store.setValue("com.fusesource.ide.jvmmonitor.tools.jdkRootDirectory", this.jdkRootDirectoryText.getText());
            store.setValue("com.fusesource.ide.jvmmonitor.tools.updatePeriod", Long.valueOf(this.updatePeriodText.getText()).longValue());
            store.setValue("com.fusesource.ide.jvmmonitor.tools.class.maxNumber", Integer.valueOf(this.maxNumberOfClassesText.getText()).intValue());
        }
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        String updatePeriod = String.valueOf(store.getDefaultInt("com.fusesource.ide.jvmmonitor.tools.updatePeriod"));
        this.updatePeriodText.setText(updatePeriod);
        this.maxNumberOfClassesText.setText(String.valueOf(this.getPreferenceStore().getDefaultInt("com.fusesource.ide.jvmmonitor.tools.class.maxNumber")));
        super.performDefaults();
    }

    private void createUpdatePeriodTextField(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.autoDetectGroupLabel);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.updatePeriodLabel);
        this.updatePeriodText = new Text((Composite)group, 2048);
        this.updatePeriodText.setText(String.valueOf(this.getPreferenceStore().getInt("com.fusesource.ide.jvmmonitor.tools.updatePeriod")));
        this.updatePeriodText.setLayoutData((Object)new GridData(768));
        this.updatePeriodText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ToolsPreferencePage.this.validateUpdatePeriod();
            }
        });
    }

    private void createJdkRootDirectoryGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(Messages.jdkRootDirectoryLabel);
        this.jdkRootDirectoryText = new Text(composite, 2048);
        this.jdkRootDirectoryText.setText(this.getPreferenceStore().getString("com.fusesource.ide.jvmmonitor.tools.jdkRootDirectory"));
        this.jdkRootDirectoryText.setLayoutData((Object)new GridData(768));
        this.jdkRootDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ToolsPreferencePage.this.validateJdkRootDirectory();
            }
        });
        Button button = new Button(composite, 0);
        button.setText(Messages.browseButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(e.display.getActiveShell());
                dialog.setMessage(Messages.selectJdkRootDirectoryMsg);
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                File file = new File(path);
                if (file.isDirectory()) {
                    ToolsPreferencePage.this.jdkRootDirectoryText.setText(path);
                }
            }
        });
    }

    private void createMemoryGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.memoryGroupLabel);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.maxNumberOfClassesLabel);
        this.maxNumberOfClassesText = new Text((Composite)group, 2048);
        this.maxNumberOfClassesText.setText(String.valueOf(this.getPreferenceStore().getInt("com.fusesource.ide.jvmmonitor.tools.class.maxNumber")));
        this.maxNumberOfClassesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ToolsPreferencePage.this.validateMaxNumberOfClasses();
            }
        });
        this.maxNumberOfClassesText.setLayoutData((Object)new GridData(768));
    }

    void validateJdkRootDirectory() {
        String jdkRootDirectory = this.jdkRootDirectoryText.getText();
        if (jdkRootDirectory.isEmpty()) {
            this.setMessage(Messages.jdkRootDirectoryNotEnteredMsg, 2);
            return;
        }
        String message = Tools.getInstance().validateJdkRootDirectory(jdkRootDirectory);
        this.setMessage(message, 2);
    }

    void validateUpdatePeriod() {
        String period = this.updatePeriodText.getText();
        if (period.isEmpty()) {
            this.setMessage(Messages.updatePeriodNotEnteredMsg, 2);
            return;
        }
        try {
            Integer.parseInt(period);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage(Messages.illegalUpdatePeriodMsg, 3);
            return;
        }
        if (Integer.valueOf(period) < 100) {
            this.setMessage(Messages.updatePeriodOutOfRangeMsg, 3);
            return;
        }
        this.setMessage(null);
    }

    void validateMaxNumberOfClasses() {
        String period = this.maxNumberOfClassesText.getText();
        if (period.isEmpty()) {
            this.setMessage(Messages.enterMaxNumberOfClassesMsg, 2);
            return;
        }
        try {
            Integer.parseInt(period);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage(Messages.maxNumberOfClassesInvalidMsg, 3);
            return;
        }
        if (Integer.valueOf(period) <= 0) {
            this.setMessage(Messages.maxNumberOfClassesOutOfRangeMsg, 3);
            return;
        }
        this.setMessage(null);
    }
}

