/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.birt.core.archive.compound.v3.Ext2Constants;
import org.eclipse.birt.core.archive.compound.v3.Ext2File;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;
import org.eclipse.birt.core.archive.compound.v3.Ext2Node;
import org.eclipse.birt.core.archive.compound.v3.FreeBlockList;

class FreeBlockTable
implements Ext2Constants {
    protected Ext2FileSystem fs;
    protected LinkedList<Ext2Node> freeNodes;
    protected Ext2Node freeNode;
    protected FreeBlockList freeBlockList;
    protected boolean dirty;
    protected boolean isLocked;

    FreeBlockTable(Ext2FileSystem fs) {
        this.fs = fs;
        this.freeNodes = new LinkedList();
        this.dirty = true;
    }

    public void read() throws IOException {
        this.freeNodes.clear();
        byte[] buffer = new byte[64];
        Ext2File file = new Ext2File(this.fs, 2, false);
        try {
            int totalNode = (int)(file.length() / 64L);
            int i = 0;
            while (i < totalNode) {
                file.read(buffer, 0, buffer.length);
                Ext2Node freeNode = new Ext2Node();
                freeNode.read(new DataInputStream(new ByteArrayInputStream(buffer)));
                this.freeNodes.add(freeNode);
                ++i;
            }
        }
        finally {
            file.close();
        }
        this.dirty = false;
    }

    protected void write() throws IOException {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        Ext2File file = new Ext2File(this.fs, 2, false);
        try {
            this.isLocked = true;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(64);
            DataOutputStream out = new DataOutputStream(buffer);
            for (Ext2Node freeNode : this.freeNodes) {
                buffer.reset();
                freeNode.write(out);
                file.write(buffer.toByteArray(), 0, 64);
            }
            if (this.freeBlockList != null) {
                buffer.reset();
                this.freeNode.write(out);
                file.write(buffer.toByteArray(), 0, 64);
            }
            file.setLength(file.getPointer());
        }
        finally {
            this.isLocked = false;
            file.close();
        }
    }

    public int getFreeBlock() throws IOException {
        int blockId;
        if (this.isLocked) {
            return -1;
        }
        if (this.freeBlockList != null) {
            blockId = this.freeBlockList.removeLastBlock();
            if (blockId > 0) {
                this.dirty = true;
                return blockId;
            }
            this.freeBlockList.clear();
            this.freeBlockList = null;
            this.freeNode = null;
        }
        while (!this.freeNodes.isEmpty()) {
            this.freeNode = this.freeNodes.removeLast();
            this.freeBlockList = new FreeBlockList(this.fs, this.freeNode);
            blockId = this.freeBlockList.removeLastBlock();
            if (blockId > 0) {
                this.dirty = true;
                return blockId;
            }
            this.freeBlockList.clear();
            this.freeBlockList = null;
            this.freeNode = null;
        }
        return -1;
    }

    public void addFreeBlocks(Ext2Node node) {
        this.dirty = true;
        this.freeNodes.add(node);
    }
}

