/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.Map;
import java.util.Properties;
import org.jclouds.javax.annotation.Nullable;

public class PropertiesBuilder {
    protected final Properties properties = this.defaultProperties();

    public PropertiesBuilder relaxSSLHostname(boolean relax) {
        this.properties.setProperty("jclouds.relax-hostname", relax + "");
        return this;
    }

    public PropertiesBuilder trustAllCerts(boolean trust) {
        this.properties.setProperty("jclouds.trust-all-certs", trust + "");
        return this;
    }

    public PropertiesBuilder useSystemProxies(boolean useSystemProxies) {
        this.properties.setProperty("jclouds.use-system-proxy", useSystemProxies + "");
        return this;
    }

    public PropertiesBuilder withProxyHost(String proxyHost) {
        this.properties.setProperty("jclouds.proxy-host", proxyHost);
        return this;
    }

    public PropertiesBuilder withProxyPort(int proxyPort) {
        this.properties.setProperty("jclouds.proxy-port", Integer.toString(proxyPort));
        return this;
    }

    public PropertiesBuilder withProxyUser(String proxyUser) {
        this.properties.setProperty("jclouds.proxy-user", proxyUser);
        return this;
    }

    public PropertiesBuilder withProxyPassword(String proxyPassword) {
        this.properties.setProperty("jclouds.proxy-password", proxyPassword);
        return this;
    }

    public PropertiesBuilder withSOTimeout(long soTimeout) {
        this.properties.setProperty("jclouds.so-timeout", Long.toString(soTimeout));
        return this;
    }

    public PropertiesBuilder withConnectionTimeout(long connectionTimeout) {
        this.properties.setProperty("jclouds.connection-timeout", Long.toString(connectionTimeout));
        return this;
    }

    public PropertiesBuilder withMaxRetries(int httpMaxRetries) {
        this.properties.setProperty("jclouds.max-retries", Integer.toString(httpMaxRetries));
        return this;
    }

    public PropertiesBuilder withRetriesDelayStart(long delayStart) {
        this.properties.setProperty("jclouds.retries-delay-start", Long.toString(delayStart));
        return this;
    }

    public PropertiesBuilder withMaxRedirects(int httpMaxRedirects) {
        this.properties.setProperty("jclouds.max-redirects", Integer.toString(httpMaxRedirects));
        return this;
    }

    public PropertiesBuilder withMaxClientReuse(int poolMaxClientReuse) {
        this.properties.setProperty("jclouds.max-connection-reuse", Integer.toString(poolMaxClientReuse));
        return this;
    }

    public PropertiesBuilder withMaxSessionFailures(int poolMaxSessionFailures) {
        this.properties.setProperty("jclouds.max-session-failures", Integer.toString(poolMaxSessionFailures));
        return this;
    }

    public PropertiesBuilder limitIoWorkerThreadsTo(int poolIoWorkerThreads) {
        this.properties.setProperty("jclouds.io-worker-threads", Integer.toString(poolIoWorkerThreads));
        return this;
    }

    public PropertiesBuilder limitUserThreadsTo(int poolIoWorkerThreads) {
        this.properties.setProperty("jclouds.user-threads", Integer.toString(poolIoWorkerThreads));
        return this;
    }

    public PropertiesBuilder limitConnectionsTo(int connectionLimit) {
        this.properties.setProperty("jclouds.max-connections-per-context", Integer.toString(connectionLimit));
        return this;
    }

    public PropertiesBuilder limitConnectionsPerHostTo(int connectionLimit) {
        this.properties.setProperty("jclouds.max-connections-per-host", Integer.toString(connectionLimit));
        return this;
    }

    public PropertiesBuilder() {
    }

    protected Properties defaultProperties() {
        Properties props = new Properties();
        props.setProperty("jclouds.iso3166-codes", "");
        props.setProperty("jclouds.max-connections-per-context", "20");
        props.setProperty("jclouds.max-connections-per-host", "0");
        props.setProperty("jclouds.so-timeout", "60000");
        props.setProperty("jclouds.connection-timeout", "60000");
        props.setProperty("jclouds.io-worker-threads", "20");
        props.setProperty("jclouds.user-threads", "0");
        props.setProperty("jclouds.build-version", "");
        props.setProperty("jclouds.max-connection-reuse", "75");
        props.setProperty("jclouds.max-session-failures", "2");
        props.setProperty("jclouds.session-interval", "60");
        return props;
    }

    public PropertiesBuilder(Properties properties) {
        this();
        this.properties.putAll((Map<?, ?>)properties);
    }

    public PropertiesBuilder provider(String providerName) {
        this.properties.setProperty("jclouds.provider", providerName);
        return this;
    }

    public PropertiesBuilder endpoint(String endpoint) {
        this.properties.setProperty("jclouds.endpoint", endpoint);
        return this;
    }

    public PropertiesBuilder iso3166Codes(Iterable<String> codes) {
        this.properties.setProperty("jclouds.iso3166-codes", Joiner.on(',').join(codes));
        return this;
    }

    public PropertiesBuilder apiVersion(String apiVersion) {
        this.properties.setProperty("jclouds.api-version", apiVersion);
        return this;
    }

    public PropertiesBuilder buildVersion(String buildVersion) {
        this.properties.setProperty("jclouds.build-version", buildVersion);
        return this;
    }

    public PropertiesBuilder credentials(String identity, @Nullable String credential) {
        this.properties.setProperty("jclouds.identity", identity);
        if (credential != null) {
            this.properties.setProperty("jclouds.credential", credential);
        }
        return this;
    }

    public PropertiesBuilder sessionInterval(long seconds) {
        this.properties.setProperty("jclouds.session-interval", seconds + "");
        return this;
    }

    @VisibleForTesting
    public Properties build() {
        return this.properties;
    }
}

