/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.binders;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindUserMetadataToHeaders
implements Binder,
Function<UserMetadata, Map<String, String>> {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof UserMetadata, "this binder is only valid for UserMetadatas!");
        Preconditions.checkNotNull(request, "request");
        return ModifyRequest.putHeaders(request, Multimaps.forMap(this.apply((UserMetadata)UserMetadata.class.cast(input))));
    }

    @Override
    public Map<String, String> apply(UserMetadata md) {
        String header;
        ImmutableMap.Builder<String, String> headers = ImmutableMap.builder();
        if (md.getMetadata().size() > 0) {
            header = Joiner.on(',').withKeyValueSeparator("=").join(md.getMetadata());
            headers.put("x-emc-meta", header);
        }
        if (md.getListableMetadata().size() > 0) {
            header = Joiner.on(',').withKeyValueSeparator("=").join(md.getListableMetadata());
            headers.put("x-emc-listable-meta", header);
        }
        if (md.getTags().size() > 0) {
            header = Joiner.on(',').join(md.getTags());
            headers.put("x-emc-tags", header);
        }
        if (md.getListableTags().size() > 0) {
            header = Joiner.on(',').join(md.getListableTags());
            headers.put("x-emc-listable-tags", header);
        }
        return headers.build();
    }
}

