/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Provides;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.config.AtmosObjectModule;
import org.jclouds.atmos.config.AtmosParserModule;
import org.jclouds.atmos.handlers.AtmosClientErrorRetryHandler;
import org.jclouds.atmos.handlers.ParseAtmosErrorFromXmlContent;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
@RequiresHttp
public class AtmosRestClientModule
extends RestClientModule<AtmosClient, AtmosAsyncClient> {
    public AtmosRestClientModule() {
        super(AtmosClient.class, AtmosAsyncClient.class);
    }

    @Override
    protected void configure() {
        this.install(new AtmosParserModule());
        this.install(new AtmosObjectModule());
        super.configure();
    }

    @Provides
    @TimeStamp
    protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
        return cache.get();
    }

    @Provides
    @TimeStamp
    Supplier<String> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds, final DateService dateService) {
        return Suppliers.memoizeWithExpiration(new Supplier<String>(){

            @Override
            public String get() {
                return dateService.rfc822DateFormat();
            }
        }, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @TimeStamp
    protected Long provideShareableUrlTimeout() {
        return new Date().getTime() + TimeUnit.HOURS.toMillis(1L);
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseAtmosErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseAtmosErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseAtmosErrorFromXmlContent.class);
    }

    @Override
    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(AtmosClientErrorRetryHandler.class);
    }
}

