/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.javax.annotation.Nullable;

public class BoundedLinkedHashSet<T>
extends LinkedHashSet<T>
implements BoundedSet<T> {
    private static final long serialVersionUID = -7133632087734650835L;
    protected final String token;

    public BoundedLinkedHashSet(Iterable<T> contents, @Nullable String token) {
        Iterables.addAll(this, Preconditions.checkNotNull(contents, "contents"));
        this.token = token;
    }

    @Override
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundedLinkedHashSet other = (BoundedLinkedHashSet)obj;
        return !(this.token == null ? other.token != null : !this.token.equals(other.token));
    }

    @Override
    public String toString() {
        return "[token=" + this.token + ", contents=" + super.toString() + "]";
    }
}

