/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.http.HttpResponse;

@Singleton
public class ParseUserMetadataFromHeaders
implements Function<HttpResponse, UserMetadata> {
    private static final Set<String> sysKeys = ImmutableSet.of("atime", "ctime", "gid", "itime", "mtime", "nlink", new String[]{"policyname", "size", "uid", "content-md5", "objectid", "objname", "type"});
    private static final Predicate<String> filter = new Predicate<String>(){

        @Override
        public boolean apply(String arg0) {
            return !sysKeys.contains(arg0);
        }
    };

    @Override
    public UserMetadata apply(HttpResponse from) {
        Preconditions.checkNotNull(from, "http response");
        Map<String, String> meta = Maps.filterKeys(this.getMetaMap(Preconditions.checkNotNull(from.getFirstHeaderOrNull("x-emc-meta"), "x-emc-meta")), filter);
        ImmutableMap<String, String> listableMeta = from.getFirstHeaderOrNull("x-emc-listable-meta") != null ? this.getMetaMap(from.getFirstHeaderOrNull("x-emc-listable-meta")) : ImmutableMap.of();
        ImmutableSet<String> tags = from.getFirstHeaderOrNull("x-emc-tags") != null ? Splitter.on(", ").split(from.getFirstHeaderOrNull("x-emc-tags")) : ImmutableSet.of();
        ImmutableSet<String> listableTags = from.getFirstHeaderOrNull("x-emc-listable-tags") != null ? Splitter.on(", ").split(from.getFirstHeaderOrNull("x-emc-listable-tags")) : ImmutableSet.of();
        return new UserMetadata(meta, listableMeta, tags, listableTags);
    }

    private Map<String, String> getMetaMap(String meta) {
        ImmutableMap.Builder<String, String> metaMap = ImmutableMap.builder();
        for (String entry : Splitter.on(", ").split(meta)) {
            String[] entrySplit = entry.split("=");
            metaMap.put(entrySplit[0], entrySplit[1]);
        }
        return metaMap.build();
    }
}

