/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.config;

import com.google.inject.Provides;
import java.util.Date;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.config.AWSRestClientModule;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.RequiresHttp;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.RequestSigner;

@ConfiguresRestClient
@RequiresHttp
public class FormSigningRestClientModule<S, A>
extends AWSRestClientModule<S, A> {
    public FormSigningRestClientModule(Class<S> syncClientType, Class<A> asyncClientType, Map<Class<?>, Class<?>> delegates) {
        super(syncClientType, asyncClientType, delegates);
    }

    public FormSigningRestClientModule(Class<S> syncClientType, Class<A> asyncClientType) {
        super(syncClientType, asyncClientType);
    }

    @Provides
    @TimeStamp
    protected String provideTimeStamp(DateService dateService, @Named(value="jclouds.session-interval") int expiration) {
        return dateService.iso8601DateFormat(new Date(System.currentTimeMillis() + (long)(expiration * 1000)));
    }

    @Provides
    @Singleton
    RequestSigner provideRequestSigner(FormSigner in) {
        return in;
    }
}

