/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindLaunchSpecificationToFormParams
implements Binder,
Function<LaunchSpecification, Map<String, String>> {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof LaunchSpecification, "this binder is only valid for LaunchSpecifications!");
        LaunchSpecification launchSpec = (LaunchSpecification)LaunchSpecification.class.cast(input);
        return ModifyRequest.putFormParams(request, Multimaps.forMap(this.apply(launchSpec)));
    }

    @Override
    public Map<String, String> apply(LaunchSpecification launchSpec) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.put("LaunchSpecification.ImageId", Preconditions.checkNotNull(launchSpec.getImageId(), "imageId"));
        if (launchSpec.getAvailabilityZone() != null) {
            builder.put("LaunchSpecification.Placement.AvailabilityZone", launchSpec.getAvailabilityZone());
        }
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        if (launchSpec.getBlockDeviceMappings().size() > 0) {
            options.withBlockDeviceMappings((Set)launchSpec.getBlockDeviceMappings());
        }
        if (launchSpec.getSecurityGroupNames().size() > 0) {
            options.withSecurityGroups(launchSpec.getSecurityGroupNames());
        }
        if (launchSpec.getSecurityGroupIds().size() > 0) {
            options.withSecurityGroupIds(launchSpec.getSecurityGroupIds());
        }
        options.asType(Preconditions.checkNotNull(launchSpec.getInstanceType(), "instanceType"));
        if (launchSpec.getKernelId() != null) {
            options.withKernelId(launchSpec.getKernelId());
        }
        if (launchSpec.getKeyName() != null) {
            options.withKeyName(launchSpec.getKeyName());
        }
        if (launchSpec.getRamdiskId() != null) {
            options.withRamdisk(launchSpec.getRamdiskId());
        }
        if (Boolean.TRUE.equals(launchSpec.isMonitoringEnabled())) {
            options.enableMonitoring();
        }
        if (launchSpec.getUserData() != null) {
            options.withUserData(launchSpec.getUserData());
        }
        for (Map.Entry<String, String> entry : options.buildFormParameters().entries()) {
            builder.put("LaunchSpecification." + entry.getKey(), entry.getValue());
        }
        return builder.build();
    }
}

