/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2AsyncClient;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.ec2.compute.strategy.EC2ListNodesStrategy;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.location.Region;

@Singleton
public class AWSEC2ListNodesStrategy
extends EC2ListNodesStrategy {
    protected final AWSEC2AsyncClient client;
    protected final SpotInstanceRequestToAWSRunningInstance spotConverter;

    @Inject
    protected AWSEC2ListNodesStrategy(AWSEC2AsyncClient client, @Region Set<String> regions, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, @Named(value="jclouds.user-threads") ExecutorService executor, SpotInstanceRequestToAWSRunningInstance spotConverter) {
        super(client, regions, runningInstanceToNodeMetadata, executor);
        this.client = Preconditions.checkNotNull(client, "client");
        this.spotConverter = Preconditions.checkNotNull(spotConverter, "spotConverter");
    }

    @Override
    protected Iterable<? extends RunningInstance> pollRunningInstances() {
        Iterable<AWSRunningInstance> spots = Iterables.filter(Iterables.transform(Iterables.concat(FutureIterables.transformParallel(this.regions, new Function<String, Future<Set<SpotInstanceRequest>>>(){

            @Override
            public Future<Set<SpotInstanceRequest>> apply(String from) {
                return AWSEC2ListNodesStrategy.this.client.getSpotInstanceServices().describeSpotInstanceRequestsInRegion(from, new String[0]);
            }
        }, this.executor, null, this.logger, "reservations")), this.spotConverter), Predicates.notNull());
        return Iterables.concat(super.pollRunningInstances(), spots);
    }
}

