/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.config.ClusterCompute;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.ec2.compute.suppliers.EC2HardwareSupplier;

@Singleton
public class AWSEC2HardwareSupplier
extends EC2HardwareSupplier {
    private final Set<String> ccAmis;

    @Inject
    public AWSEC2HardwareSupplier(@ClusterCompute Set<String> ccAmis) {
        this.ccAmis = ccAmis;
    }

    @Override
    public Set<? extends Hardware> get() {
        ImmutableSet.Builder sizes = ImmutableSet.builder();
        sizes.add(EC2HardwareBuilder.cc1_4xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add(EC2HardwareBuilder.cg1_4xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add(EC2HardwareBuilder.cc2_8xlarge().supportsImageIds(this.ccAmis).build());
        sizes.addAll(ImmutableSet.of(EC2HardwareBuilder.t1_micro().build(), EC2HardwareBuilder.c1_medium().build(), EC2HardwareBuilder.c1_xlarge().build(), EC2HardwareBuilder.m1_large().build(), EC2HardwareBuilder.m1_small().build(), EC2HardwareBuilder.m1_medium().build(), new Hardware[]{EC2HardwareBuilder.m1_xlarge().build(), EC2HardwareBuilder.m2_xlarge().build(), EC2HardwareBuilder.m2_2xlarge().build(), EC2HardwareBuilder.m2_4xlarge().build()}));
        return sizes.build();
    }
}

