/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.config.ClusterCompute;
import org.jclouds.aws.ec2.compute.suppliers.CallForImages;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.ImagesToRegionAndIdMap;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class AWSEC2ImageSupplier
implements Supplier<Set<? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Set<String> clusterComputeIds;
    private final CallForImages.Factory factory;
    private final ExecutorService executor;
    private final Iterable<String> regions;
    private final String amiQuery;
    private final Iterable<String> clusterRegions;
    private final String ccAmiQuery;
    private final Supplier<LoadingCache<RegionAndName, ? extends Image>> cache;

    @Inject
    protected AWSEC2ImageSupplier(@Region Set<String> regions, @Named(value="jclouds.ec2.ami-query") String amiQuery, @Named(value="jclouds.ec2.cc-regions") String clusterRegions, @Named(value="jclouds.ec2.cc-ami-query") String ccAmiQuery, Supplier<LoadingCache<RegionAndName, ? extends Image>> cache, CallForImages.Factory factory, @ClusterCompute Set<String> clusterComputeIds, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.factory = factory;
        this.regions = regions;
        this.amiQuery = amiQuery;
        this.clusterRegions = Splitter.on(',').split(clusterRegions);
        this.ccAmiQuery = ccAmiQuery;
        this.cache = cache;
        this.clusterComputeIds = clusterComputeIds;
        this.executor = executor;
    }

    @Override
    public Set<? extends Image> get() {
        ImmutableSet<Image> parsedImages;
        ImmutableSet<Image> clusterImages;
        Future<Iterable<Image>> normalImages = this.images(this.regions, this.amiQuery, "jclouds.ec2.ami-query");
        try {
            clusterImages = ImmutableSet.copyOf(this.images(this.clusterRegions, this.ccAmiQuery, "jclouds.ec2.cc-ami-query").get());
        }
        catch (Exception e) {
            this.logger.warn(e, "Error parsing images in query %s", this.ccAmiQuery);
            throw Throwables.propagate(e);
        }
        Iterables.addAll(this.clusterComputeIds, Iterables.transform(clusterImages, new Function<Image, String>(){

            @Override
            public String apply(Image arg0) {
                return arg0.getId();
            }
        }));
        try {
            parsedImages = ImmutableSet.copyOf(Iterables.concat(clusterImages, normalImages.get()));
        }
        catch (Exception e) {
            this.logger.warn(e, "Error parsing images in query %s", this.amiQuery);
            throw Throwables.propagate(e);
        }
        Map<RegionAndName, ? extends Image> imageMap = ImagesToRegionAndIdMap.imagesToMap(parsedImages);
        this.cache.get().invalidateAll();
        this.cache.get().asMap().putAll(imageMap);
        this.logger.debug("<< images(%d)", imageMap.size());
        return new ForwardingSet<Image>(){

            @Override
            protected Set<Image> delegate() {
                return ImmutableSet.copyOf(((LoadingCache)AWSEC2ImageSupplier.this.cache.get()).asMap().values());
            }
        };
    }

    private Future<Iterable<Image>> images(Iterable<String> regions, String query, String tag) {
        if (query.equals("")) {
            this.logger.debug(">> no %s specified, skipping image parsing", tag);
            return Futures.immediateFuture(ImmutableSet.of());
        }
        return this.executor.submit(this.factory.parseImagesFromRegionsUsingFilter(regions, QueryStringToMultimap.INSTANCE.apply(query)));
    }

    public static enum QueryStringToMultimap implements Function<String, Multimap<String, String>>
    {
        INSTANCE;


        @Override
        public Multimap<String, String> apply(String arg0) {
            ImmutableMultimap.Builder<String, Object> builder = ImmutableMultimap.builder();
            for (String pair : Splitter.on(';').split(arg0)) {
                String[] keyValue = pair.split("=");
                if (keyValue.length == 1) {
                    builder.putAll(keyValue[0], ImmutableSet.of());
                    continue;
                }
                builder.putAll(keyValue[0], Splitter.on(',').split(keyValue[1]));
            }
            return builder.build();
        }
    }
}

