/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.options.AWSDescribeImagesOptions;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.compute.strategy.DescribeImagesParallel;
import org.jclouds.logging.Logger;

@Singleton
public class CallForImages
implements Callable<Iterable<Image>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Iterable<String> regions;
    private final DescribeImagesParallel describer;
    private final EC2ImageParser parser;
    private final Multimap<String, String> filter;

    @Inject
    protected CallForImages(DescribeImagesParallel describer, EC2ImageParser parser, @Assisted Iterable<String> regions, @Assisted Multimap<String, String> filter) {
        this.regions = regions;
        this.describer = describer;
        this.filter = filter;
        this.parser = parser;
    }

    @Override
    public Iterable<Image> call() {
        this.logger.debug(">> providing images", new Object[0]);
        ImmutableMap.Builder<String, AWSDescribeImagesOptions> builder = ImmutableMap.builder();
        for (String region : this.regions) {
            builder.put(region, AWSDescribeImagesOptions.Builder.filters(this.filter));
        }
        Set queries = builder.build().entrySet();
        Iterable<Image> returnVal = Iterables.filter(Iterables.transform(this.describer.apply(queries), this.parser), Predicates.notNull());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<< images(%s)", Iterables.size(returnVal));
        }
        return returnVal;
    }

    public String toString() {
        return String.format("desribingImages(filter=%s,regions=%s)", this.filter, this.regions);
    }

    public static interface Factory {
        public CallForImages parseImagesFromRegionsUsingFilter(Iterable<String> var1, Multimap<String, String> var2);
    }
}

