/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.javax.annotation.Nullable;

public class SpotInstanceRequest
implements Comparable<SpotInstanceRequest> {
    private final String region;
    private final String availabilityZoneGroup;
    private final String launchedAvailabilityZone;
    private final Date createTime;
    private final String faultCode;
    private final String faultMessage;
    private final String instanceId;
    private final String launchGroup;
    private final LaunchSpecification launchSpecification;
    private final String productDescription;
    private final String id;
    private final float spotPrice;
    private final State state;
    private final Type type;
    private final Date validFrom;
    private final Date validUntil;
    private final Map<String, String> tags;

    public static Builder builder() {
        return new Builder();
    }

    public SpotInstanceRequest(String region, String availabilityZoneGroup, @Nullable String launchedAvailabilityZone, Date createTime, String faultCode, String faultMessage, String instanceId, String launchGroup, LaunchSpecification launchSpecification, String productDescription, String id, float spotPrice, State state, Type type, Date validFrom, Date validUntil, Map<String, String> tags) {
        this.region = Preconditions.checkNotNull(region, "region");
        this.availabilityZoneGroup = availabilityZoneGroup;
        this.launchedAvailabilityZone = launchedAvailabilityZone;
        this.createTime = createTime;
        this.faultCode = faultCode;
        this.faultMessage = faultMessage;
        this.instanceId = instanceId;
        this.launchGroup = launchGroup;
        this.launchSpecification = launchSpecification;
        this.productDescription = productDescription;
        this.id = Preconditions.checkNotNull(id, "id");
        this.spotPrice = spotPrice;
        this.state = Preconditions.checkNotNull(state, "state");
        this.type = Preconditions.checkNotNull(type, "type");
        this.validFrom = validFrom;
        this.validUntil = validUntil;
        this.tags = ImmutableMap.copyOf(Preconditions.checkNotNull(tags, "tags"));
    }

    public String getRegion() {
        return this.region;
    }

    public String getAvailabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public String getLaunchedAvailabilityZone() {
        return this.launchedAvailabilityZone;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultMessage() {
        return this.faultMessage;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getLaunchGroup() {
        return this.launchGroup;
    }

    public LaunchSpecification getLaunchSpecification() {
        return this.launchSpecification;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public String getId() {
        return this.id;
    }

    public float getSpotPrice() {
        return this.spotPrice;
    }

    public State getState() {
        return this.state;
    }

    public Type getType() {
        return this.type;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.availabilityZoneGroup == null ? 0 : this.availabilityZoneGroup.hashCode());
        result = 31 * result + (this.createTime == null ? 0 : this.createTime.hashCode());
        result = 31 * result + (this.faultCode == null ? 0 : this.faultCode.hashCode());
        result = 31 * result + (this.faultMessage == null ? 0 : this.faultMessage.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.launchGroup == null ? 0 : this.launchGroup.hashCode());
        result = 31 * result + (this.launchSpecification == null ? 0 : this.launchSpecification.hashCode());
        result = 31 * result + (this.launchedAvailabilityZone == null ? 0 : this.launchedAvailabilityZone.hashCode());
        result = 31 * result + (this.productDescription == null ? 0 : this.productDescription.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + Float.floatToIntBits(this.spotPrice);
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.validFrom == null ? 0 : this.validFrom.hashCode());
        result = 31 * result + (this.validUntil == null ? 0 : this.validUntil.hashCode());
        result = 31 * result + (this.tags == null ? 0 : ((Object)this.tags).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpotInstanceRequest other = (SpotInstanceRequest)obj;
        if (this.availabilityZoneGroup == null ? other.availabilityZoneGroup != null : !this.availabilityZoneGroup.equals(other.availabilityZoneGroup)) {
            return false;
        }
        if (this.createTime == null ? other.createTime != null : !this.createTime.equals(other.createTime)) {
            return false;
        }
        if (this.faultCode == null ? other.faultCode != null : !this.faultCode.equals(other.faultCode)) {
            return false;
        }
        if (this.faultMessage == null ? other.faultMessage != null : !this.faultMessage.equals(other.faultMessage)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.launchGroup == null ? other.launchGroup != null : !this.launchGroup.equals(other.launchGroup)) {
            return false;
        }
        if (this.launchSpecification == null ? other.launchSpecification != null : !this.launchSpecification.equals(other.launchSpecification)) {
            return false;
        }
        if (this.launchedAvailabilityZone == null ? other.launchedAvailabilityZone != null : !this.launchedAvailabilityZone.equals(other.launchedAvailabilityZone)) {
            return false;
        }
        if (this.productDescription == null ? other.productDescription != null : !this.productDescription.equals(other.productDescription)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (Float.floatToIntBits(this.spotPrice) != Float.floatToIntBits(other.spotPrice)) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.validFrom == null ? other.validFrom != null : !this.validFrom.equals(other.validFrom)) {
            return false;
        }
        if (this.validUntil == null ? other.validUntil != null : !this.validUntil.equals(other.validUntil)) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !((Object)this.tags).equals(other.tags));
    }

    public String toString() {
        return "[region=" + this.region + ", availabilityZoneGroup=" + this.availabilityZoneGroup + ", launchedAvailabilityZone=" + this.launchedAvailabilityZone + ", createTime=" + this.createTime + ", faultCode=" + this.faultCode + ", faultMessage=" + this.faultMessage + ", instanceId=" + this.instanceId + ", launchGroup=" + this.launchGroup + ", launchSpecification=" + this.launchSpecification + ", productDescription=" + this.productDescription + ", id=" + this.id + ", spotPrice=" + this.spotPrice + ", state=" + (Object)((Object)this.state) + ", type=" + (Object)((Object)this.type) + ", validFrom=" + this.validFrom + ", validUntil=" + this.validUntil + ", tags=" + this.tags + "]";
    }

    @Override
    public int compareTo(SpotInstanceRequest arg0) {
        return this.createTime.compareTo(arg0.createTime);
    }

    public static enum State {
        OPEN,
        ACTIVE,
        CANCELLED,
        CLOSED,
        UNRECOGNIZED;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(state, "type")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        ONE_TIME,
        PERSISTENT,
        UNRECOGNIZED;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static Type fromValue(String type) {
            try {
                return Type.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(type, "type")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private String region;
        private String availabilityZoneGroup;
        private String launchedAvailabilityZone;
        private Date createTime;
        private String faultCode;
        private String faultMessage;
        private String instanceId;
        private String launchGroup;
        private LaunchSpecification launchSpecification;
        private String productDescription;
        private String id;
        private float spotPrice;
        private State state;
        private Type type;
        private Date validFrom;
        private Date validUntil;
        private Map<String, String> tags = Maps.newLinkedHashMap();

        public Builder clear() {
            this.region = null;
            this.availabilityZoneGroup = null;
            this.launchedAvailabilityZone = null;
            this.createTime = null;
            this.faultCode = null;
            this.faultMessage = null;
            this.instanceId = null;
            this.launchGroup = null;
            this.launchSpecification = null;
            this.productDescription = null;
            this.id = null;
            this.spotPrice = 0.0f;
            this.state = null;
            this.type = null;
            this.validFrom = null;
            this.validUntil = null;
            this.tags = Maps.newLinkedHashMap();
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = ImmutableMap.copyOf(Preconditions.checkNotNull(tags, "tags"));
            return this;
        }

        public Builder tag(String key, String value) {
            if (key != null) {
                this.tags.put(key, Strings.nullToEmpty(value));
            }
            return this;
        }

        public Builder availabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
            return this;
        }

        public Builder launchedAvailabilityZone(String launchedAvailabilityZone) {
            this.launchedAvailabilityZone = launchedAvailabilityZone;
            return this;
        }

        public Builder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder faultCode(String faultCode) {
            this.faultCode = faultCode;
            return this;
        }

        public Builder faultMessage(String faultMessage) {
            this.faultMessage = faultMessage;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder launchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
            return this;
        }

        public Builder launchSpecification(LaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder spotPrice(float spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder validFrom(Date validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public Builder validUntil(Date validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public SpotInstanceRequest build() {
            return new SpotInstanceRequest(this.region, this.availabilityZoneGroup, this.launchedAvailabilityZone, this.createTime, this.faultCode, this.faultMessage, this.instanceId, this.launchGroup, this.launchSpecification, this.productDescription, this.id, this.spotPrice, this.state, this.type, this.validFrom, this.validUntil, this.tags);
        }
    }
}

