/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.inject.Singleton;
import org.jclouds.crypto.CryptoStreams;

@Singleton
public class EncodedRSAPublicKeyToBase64
implements Function<Object, String> {
    private static final Predicate<Object> ALLOWED_MARKERS = Predicates.or(EncodedRSAPublicKeyToBase64.startsWith("ssh-rsa"), EncodedRSAPublicKeyToBase64.startsWith("-----BEGIN CERTIFICATE-----"), EncodedRSAPublicKeyToBase64.startsWith("---- BEGIN SSH2 PUBLIC KEY ----"));

    private static Predicate<Object> startsWith(String value) {
        return new ToStringStartsWith(value);
    }

    @Override
    public String apply(Object from) {
        Preconditions.checkNotNull(from, "input");
        Preconditions.checkArgument(ALLOWED_MARKERS.apply(from), "must be a ssh public key, conforming to %s ", ALLOWED_MARKERS);
        return CryptoStreams.base64(from.toString().getBytes(Charsets.UTF_8));
    }

    private static final class ToStringStartsWith
    implements Predicate<Object> {
        private final String value;

        private ToStringStartsWith(String value) {
            this.value = value;
        }

        @Override
        public boolean apply(Object input) {
            return input.toString().startsWith(this.value);
        }

        public String toString() {
            return "toStringStartsWith(" + this.value + ")";
        }
    }
}

