/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.xml.AWSDescribeInstancesResponseHandler;
import org.jclouds.aws.ec2.xml.AWSRunInstancesResponseHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.IfNotNullBindAvailabilityZoneToFormParam;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.ec2.services.InstanceAsyncClient;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"2011-05-15"})
@VirtualHost
public interface AWSInstanceAsyncClient
extends InstanceAsyncClient {
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeInstances"})
    @XMLResponseParser(value=AWSDescribeInstancesResponseHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<? extends Reservation<? extends AWSRunningInstance>>> describeInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RunInstances"})
    @XMLResponseParser(value=AWSRunInstancesResponseHandler.class)
    public ListenableFuture<Reservation<? extends AWSRunningInstance>> runInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @Nullable @BinderParam(value=IfNotNullBindAvailabilityZoneToFormParam.class) String var2, @FormParam(value="ImageId") String var3, @FormParam(value="MinCount") int var4, @FormParam(value="MaxCount") int var5, RunInstancesOptions ... var6);
}

