/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.ec2.options.CreateSecurityGroupOptions;
import org.jclouds.aws.ec2.xml.CreateSecurityGroupResponseHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindIpPermissionToIndexedFormParams;
import org.jclouds.ec2.binders.BindIpPermissionsToIndexedFormParams;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.services.SecurityGroupAsyncClient;
import org.jclouds.ec2.xml.DescribeSecurityGroupsResponseHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"2011-05-15"})
@VirtualHost
@Beta
public interface AWSSecurityGroupAsyncClient
extends SecurityGroupAsyncClient {
    @POST
    @Path(value="/")
    @XMLResponseParser(value=CreateSecurityGroupResponseHandler.class)
    @FormParams(keys={"Action"}, values={"CreateSecurityGroup"})
    public ListenableFuture<String> createSecurityGroupInRegionAndReturnId(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2, @FormParam(value="GroupDescription") String var3, CreateSecurityGroupOptions ... var4);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"AuthorizeSecurityGroupIngress"})
    public ListenableFuture<Void> authorizeSecurityGroupIngressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupId") String var2, @BinderParam(value=BindIpPermissionToIndexedFormParams.class) IpPermission var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"AuthorizeSecurityGroupIngress"})
    public ListenableFuture<Void> authorizeSecurityGroupIngressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupId") String var2, @BinderParam(value=BindIpPermissionsToIndexedFormParams.class) Iterable<IpPermission> var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RevokeSecurityGroupIngress"})
    public ListenableFuture<Void> revokeSecurityGroupIngressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupId") String var2, @BinderParam(value=BindIpPermissionToIndexedFormParams.class) IpPermission var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RevokeSecurityGroupIngress"})
    public ListenableFuture<Void> revokeSecurityGroupIngressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupId") String var2, @BinderParam(value=BindIpPermissionsToIndexedFormParams.class) Iterable<IpPermission> var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteSecurityGroup"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteSecurityGroupInRegionById(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupId") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSecurityGroups"})
    @XMLResponseParser(value=DescribeSecurityGroupsResponseHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<SecurityGroup>> describeSecurityGroupsInRegionById(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);
}

