/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.Sets;
import com.google.inject.Provider;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.xml.BaseAWSReservationHandler;
import org.jclouds.aws.ec2.xml.TagSetHandler;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.location.Region;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AWSDescribeInstancesResponseHandler
extends BaseAWSReservationHandler<Set<Reservation<? extends RunningInstance>>> {
    private Set<Reservation<? extends RunningInstance>> reservations = Sets.newLinkedHashSet();
    private boolean inTagSet;
    private String key;
    private String value;

    @Inject
    AWSDescribeInstancesResponseHandler(DateService dateService, @Region String defaultRegion, Provider<AWSRunningInstance.Builder> builderProvider, TagSetHandler tagSetHandler) {
        super(dateService, defaultRegion, builderProvider);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        super.startElement(uri, localName, qName, attrs);
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = false;
        } else if (this.inTagSet) {
            if (SaxUtils.equalsOrSuffix(qName, "key")) {
                this.key = SaxUtils.currentOrNull(this.currentText);
            } else if (SaxUtils.equalsOrSuffix(qName, "value")) {
                this.value = SaxUtils.currentOrNull(this.currentText);
            }
        }
        super.endElement(uri, name, qName);
    }

    @Override
    public Set<Reservation<? extends RunningInstance>> getResult() {
        return this.reservations;
    }

    protected boolean endOfReservationItem() {
        return this.itemDepth == 1;
    }

    @Override
    protected void inItem() {
        if (this.endOfReservationItem()) {
            this.reservations.add(super.newReservation());
        } else if (this.inTagSet) {
            this.builder.tag(this.key, this.value);
            this.key = null;
            this.value = null;
        } else {
            super.inItem();
        }
    }

    @Override
    protected boolean endOfInstanceItem() {
        return this.itemDepth == 2 && this.inInstancesSet;
    }
}

