/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;

public class AWSClientErrorRetryHandler
implements HttpRetryHandler {
    @Inject(optional=true)
    @Named(value="jclouds.max-retries")
    private int retryCountLimit = 5;
    private final AWSUtils utils;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public AWSClientErrorRetryHandler(AWSUtils utils) {
        this.utils = utils;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        if (command.getFailureCount() > this.retryCountLimit) {
            return false;
        }
        if (response.getStatusCode() == 400 || response.getStatusCode() == 403 || response.getStatusCode() == 409) {
            command.incrementFailureCount();
            if (response.getPayload() != null) {
                HttpUtils.closeClientButKeepContentStream(response);
                AWSError error = this.utils.parseAWSErrorFromContent(command.getCurrentRequest(), response);
                if (error != null && ("RequestTimeout".equals(error.getCode()) || "OperationAborted".equals(error.getCode()) || "SignatureDoesNotMatch".equals(error.getCode()))) {
                    return true;
                }
            }
        }
        return false;
    }
}

