/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.binders;

import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.binders.BindAsHostPrefix;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.binders.BindAsHostPrefixIfConfigured;

@Singleton
public class AssignCorrectHostnameAndBindAsHostPrefixIfConfigured
extends BindAsHostPrefixIfConfigured {
    private final Map<String, String> bucketToRegion;
    private final RegionToEndpointOrProviderIfNull r2;

    @Inject
    public AssignCorrectHostnameAndBindAsHostPrefixIfConfigured(BindAsHostPrefix bindAsHostPrefix, RegionToEndpointOrProviderIfNull r2, Provider<UriBuilder> uriBuilderProvider, @Bucket Map<String, String> bucketToRegion) {
        super(bindAsHostPrefix, true, "/", uriBuilderProvider);
        this.bucketToRegion = bucketToRegion;
        this.r2 = r2;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        String bucket = payload.toString();
        String region = this.bucketToRegion.get(bucket);
        if (region != null) {
            URI endpoint = this.r2.apply(region);
            request = ModifyRequest.endpoint(request, ((UriBuilder)this.uriBuilderProvider.get()).uri(endpoint).path(request.getEndpoint().getPath()).replaceQuery(request.getEndpoint().getQuery()).build(new Object[0]));
        }
        return super.bindToRequest(request, payload);
    }
}

