/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.config;

import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import org.jclouds.aws.s3.AWSS3AsyncClient;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.aws.s3.blobstore.AWSS3AsyncBlobStore;
import org.jclouds.aws.s3.blobstore.AWSS3BlobStore;
import org.jclouds.aws.s3.blobstore.strategy.AsyncMultipartUploadStrategy;
import org.jclouds.aws.s3.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.aws.s3.blobstore.strategy.internal.ParallelMultipartUploadStrategy;
import org.jclouds.aws.s3.blobstore.strategy.internal.SequentialMultipartUploadStrategy;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.internal.BlobStoreContextImpl;
import org.jclouds.s3.blobstore.S3AsyncBlobStore;
import org.jclouds.s3.blobstore.S3BlobStore;
import org.jclouds.s3.blobstore.config.S3BlobStoreContextModule;

public class AWSS3BlobStoreContextModule
extends S3BlobStoreContextModule {
    @Override
    protected void configure() {
        super.configure();
        this.bind(S3AsyncBlobStore.class).to(AWSS3AsyncBlobStore.class).in(Scopes.SINGLETON);
        this.bind(S3BlobStore.class).to(AWSS3BlobStore.class).in(Scopes.SINGLETON);
        this.bind(MultipartUploadStrategy.class).to(SequentialMultipartUploadStrategy.class);
        this.bind(AsyncMultipartUploadStrategy.class).to(ParallelMultipartUploadStrategy.class);
    }

    @Override
    protected void bindContext() {
        this.bind(BlobStoreContext.class).to((TypeLiteral<BlobStoreContext>)new TypeLiteral<BlobStoreContextImpl<AWSS3Client, AWSS3AsyncClient>>(){}).in(Scopes.SINGLETON);
    }
}

