/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.aws.s3.blobstore.AWSS3BlobStore;
import org.jclouds.aws.s3.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.aws.s3.blobstore.strategy.internal.MultipartUploadSlicingAlgorithm;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.logging.Logger;
import org.jclouds.s3.domain.ObjectMetadataBuilder;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.util.Throwables2;

public class SequentialMultipartUploadStrategy
implements MultipartUploadStrategy {
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    protected final AWSS3BlobStore ablobstore;
    protected final PayloadSlicer slicer;

    @Inject
    public SequentialMultipartUploadStrategy(AWSS3BlobStore ablobstore, PayloadSlicer slicer) {
        this.ablobstore = Preconditions.checkNotNull(ablobstore, "ablobstore");
        this.slicer = Preconditions.checkNotNull(slicer, "slicer");
    }

    protected void prepareUploadPart(String container, String key, String uploadId, int part, Payload payload, long offset, long size, SortedMap<Integer, String> etags) {
        AWSS3Client client = (AWSS3Client)this.ablobstore.getContext().getProviderSpecificContext().getApi();
        Payload chunkedPart = this.slicer.slice(payload, offset, size);
        String eTag = null;
        try {
            eTag = client.uploadPart(container, key, part, uploadId, chunkedPart);
            etags.put(new Integer(part), eTag);
        }
        catch (KeyNotFoundException e) {
            eTag = client.uploadPart(container, key, part, uploadId, chunkedPart);
            etags.put(new Integer(part), eTag);
        }
    }

    @Override
    public String execute(String container, Blob blob, PutOptions options) {
        String key = blob.getMetadata().getName();
        Payload payload = blob.getPayload();
        MultipartUploadSlicingAlgorithm algorithm = new MultipartUploadSlicingAlgorithm();
        algorithm.calculateChunkSize(Preconditions.checkNotNull(payload.getContentMetadata().getContentLength(), "contentLength required on all uploads to amazon s3; please invoke payload.getContentMetadata().setContentLength(length) first"));
        int parts = algorithm.getParts();
        long chunkSize = algorithm.getChunkSize();
        if (parts > 0) {
            AWSS3Client client = (AWSS3Client)this.ablobstore.getContext().getProviderSpecificContext().getApi();
            String uploadId = client.initiateMultipartUpload(container, ObjectMetadataBuilder.create().key(key).build(), new PutObjectOptions[0]);
            try {
                int part;
                TreeMap<Integer, String> etags = Maps.newTreeMap();
                while ((part = algorithm.getNextPart()) <= parts) {
                    this.prepareUploadPart(container, key, uploadId, part, payload, algorithm.getNextChunkOffset(), chunkSize, etags);
                }
                long remaining = algorithm.getRemaining();
                if (remaining > 0L) {
                    this.prepareUploadPart(container, key, uploadId, part, payload, algorithm.getNextChunkOffset(), remaining, etags);
                }
                return client.completeMultipartUpload(container, key, uploadId, etags);
            }
            catch (Exception ex) {
                RuntimeException rtex = Throwables2.getFirstThrowableOfType(ex, RuntimeException.class);
                if (rtex == null) {
                    rtex = new RuntimeException(ex);
                }
                client.abortMultipartUpload(container, key, uploadId);
                throw rtex;
            }
        }
        return this.ablobstore.putBlob(container, blob, PutOptions.NONE);
    }
}

