/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.domain.Region;
import org.jclouds.aws.xml.ErrorHandler;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class AWSUtils {
    private final RequestSigner signer;
    private final ParseSax.Factory factory;
    private final Provider<ErrorHandler> errorHandlerProvider;
    private final String requestId;
    private final String requestToken;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    AWSUtils(@Named(value="jclouds.aws.header.tag") String headerTag, RequestSigner signer, ParseSax.Factory factory, Provider<ErrorHandler> errorHandlerProvider) {
        this.signer = signer;
        this.factory = factory;
        this.errorHandlerProvider = errorHandlerProvider;
        this.requestId = String.format("x-%s-request-id", headerTag);
        this.requestToken = String.format("x-%s-id-2", headerTag);
    }

    public AWSError parseAWSErrorFromContent(HttpRequest request, HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        if (response.getPayload().getContentMetadata().getContentType() != null && response.getPayload().getContentMetadata().getContentType().indexOf("text/plain") != -1) {
            return null;
        }
        try {
            AWSError error = (AWSError)((ParseSax)this.factory.create(this.errorHandlerProvider.get()).setContext(request)).apply(response);
            if (error.getRequestId() == null) {
                error.setRequestId(response.getFirstHeaderOrNull(this.requestId));
            }
            error.setRequestToken(response.getFirstHeaderOrNull(this.requestToken));
            if ("SignatureDoesNotMatch".equals(error.getCode())) {
                error.setStringSigned(this.signer.createStringToSign(request));
                error.setSignature(this.signer.sign(error.getStringSigned()));
            }
            return error;
        }
        catch (RuntimeException e) {
            this.logger.warn(e, "error parsing error", new Object[0]);
            return null;
        }
    }

    public static <R extends HttpRequest> R indexStringArrayToFormValuesWithStringFormat(R request, String format, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof String[], "this binder is only valid for String[] : " + input.getClass());
        String[] values = (String[])input;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        for (int i = 0; i < values.length; ++i) {
            builder.put(String.format(format, i + 1), Preconditions.checkNotNull(values[i], format.toLowerCase() + "s[" + i + "]"));
        }
        ImmutableMultimap<String, String> forms = builder.build();
        return forms.size() == 0 ? request : ModifyRequest.putFormParams(request, forms);
    }

    public static boolean isRegion(String regionName) {
        return Region.DEFAULT_REGIONS.contains(regionName);
    }

    public static <R extends HttpRequest> R indexIterableToFormValuesWithPrefix(R request, String prefix, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Iterable, "this binder is only valid for Iterable<?>: " + input.getClass());
        Iterable values = (Iterable)input;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        int i = 0;
        for (Object o : values) {
            builder.put(prefix + "." + (i++ + 1), Preconditions.checkNotNull(o.toString(), prefix.toLowerCase() + "s[" + i + "]"));
        }
        ImmutableMultimap<String, String> forms = builder.build();
        return forms.size() == 0 ? request : ModifyRequest.putFormParams(request, forms);
    }

    public static <R extends HttpRequest> R indexStringArrayToFormValuesWithPrefix(R request, String prefix, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof String[], "this binder is only valid for String[] : " + input.getClass());
        String[] values = (String[])input;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        for (int i = 0; i < values.length; ++i) {
            builder.put(prefix + "." + (i + 1), Preconditions.checkNotNull(values[i], prefix.toLowerCase() + "s[" + i + "]"));
        }
        ImmutableMultimap<String, String> forms = builder.build();
        return forms.size() == 0 ? request : ModifyRequest.putFormParams(request, forms);
    }

    public static <R extends HttpRequest> R indexMapToFormValuesWithPrefix(R request, String prefix, String keySuffix, String valueSuffix, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Map, "this binder is only valid for Map<?,?>: " + input.getClass());
        Map map = (Map)input;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        int i = 1;
        for (Map.Entry e : map.entrySet()) {
            builder.put(prefix + "." + i + "." + keySuffix, Preconditions.checkNotNull(e.getKey().toString(), keySuffix.toLowerCase() + "s[" + i + "]"));
            if (e.getValue() != null) {
                builder.put(prefix + "." + i + "." + valueSuffix, e.getValue().toString());
            }
            ++i;
        }
        ImmutableMultimap<String, String> forms = builder.build();
        return forms.size() == 0 ? request : ModifyRequest.putFormParams(request, forms);
    }

    public static <R extends HttpRequest> R indexMultimapToFormValuesWithPrefix(R request, String prefix, String keySuffix, String valueSuffix, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Multimap, "this binder is only valid for Multimap<?,?>: " + input.getClass());
        Multimap map = (Multimap)input;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        int i = 1;
        for (Object k : map.keySet()) {
            builder.put(prefix + "." + i + "." + keySuffix, Preconditions.checkNotNull(k.toString(), keySuffix.toLowerCase() + "s[" + i + "]"));
            int j = 1;
            for (Object v : map.get(k)) {
                builder.put(prefix + "." + i + "." + valueSuffix + "." + j, v.toString());
                ++j;
            }
            ++i;
        }
        ImmutableMultimap<String, String> forms = builder.build();
        return forms.size() == 0 ? request : ModifyRequest.putFormParams(request, forms);
    }

    public static <R extends HttpRequest> R indexMapOfIterableToFormValuesWithPrefix(R request, String prefix, String keySuffix, String valueSuffix, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Map, "this binder is only valid for Map<?,Iterable<?>>: " + input.getClass());
        Map map = (Map)input;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        int i = 1;
        for (Object k : map.keySet()) {
            builder.put(prefix + "." + i + "." + keySuffix, Preconditions.checkNotNull(k.toString(), keySuffix.toLowerCase() + "s[" + i + "]"));
            if (!Iterables.isEmpty((Iterable)map.get(k))) {
                int j = 1;
                for (Object v : (Iterable)map.get(k)) {
                    builder.put(prefix + "." + i + "." + valueSuffix + "." + j, v.toString());
                    ++j;
                }
            }
            ++i;
        }
        ImmutableMultimap<String, String> forms = builder.build();
        return forms.size() == 0 ? request : ModifyRequest.putFormParams(request, forms);
    }

    public static String getRegionFromLocationOrNull(Location location) {
        return location.getScope() == LocationScope.ZONE ? location.getParent().getId() : location.getId();
    }

    public static String[] parseHandle(String id) {
        String[] stringArray;
        String[] parts = Preconditions.checkNotNull(id, "id").split("/");
        if (parts.length == 1) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = null;
            stringArray = stringArray2;
            stringArray2[1] = id;
        } else {
            stringArray = parts;
        }
        return stringArray;
    }

    public static String findRegionInArgsOrNull(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            String regionName;
            if (!(arg instanceof String) || !AWSUtils.isRegion(regionName = (String)arg)) continue;
            return regionName;
        }
        return null;
    }

    @Singleton
    public static class GetRegionFromLocation
    implements Function<Location, String> {
        @Override
        public String apply(Location location) {
            String region = location.getScope() == LocationScope.REGION ? location.getId() : location.getParent().getId();
            return region;
        }
    }
}

