/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage;

import java.util.Properties;
import java.util.regex.Pattern;
import org.jclouds.PropertiesBuilder;
import org.jclouds.util.Strings2;

public class AzureStoragePropertiesBuilder
extends PropertiesBuilder {
    public static final Pattern IDENTITY_PATTERN = Pattern.compile("\\{identity\\}");

    public AzureStoragePropertiesBuilder() {
        this(new Properties());
    }

    public AzureStoragePropertiesBuilder(Properties properties) {
        super(properties);
    }

    @Override
    public Properties build() {
        String endpoint = this.properties.getProperty("jclouds.endpoint");
        String identity = this.properties.getProperty("jclouds.identity");
        this.properties.setProperty("jclouds.endpoint", Strings2.replaceAll(endpoint, IDENTITY_PATTERN, identity));
        return super.build();
    }
}

