/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListOptions
extends BaseHttpRequestOptions {
    public static final ListOptions NONE = new ListOptions();

    public ListOptions includeMetadata() {
        this.queryParameters.replaceValues("include", ImmutableSet.of("metadata"));
        return this;
    }

    public boolean getIncludeMetadata() {
        return this.getFirstQueryOrNull("include").equals("metadata");
    }

    public ListOptions prefix(String prefix) {
        this.queryParameters.put("prefix", Preconditions.checkNotNull(prefix, "prefix"));
        return this;
    }

    public String getPrefix() {
        return this.getFirstQueryOrNull("prefix");
    }

    public ListOptions marker(String marker) {
        this.queryParameters.put("marker", Preconditions.checkNotNull(marker, "marker"));
        return this;
    }

    public String getMarker() {
        return this.getFirstQueryOrNull("marker");
    }

    public ListOptions maxResults(int maxresults) {
        Preconditions.checkState(maxresults >= 0, "maxresults must be >= 0");
        Preconditions.checkState(maxresults <= 10000, "maxresults must be <= 5000");
        this.queryParameters.put("maxresults", Integer.toString(maxresults));
        return this;
    }

    public Integer getMaxResults() {
        String maxresults = this.getFirstQueryOrNull("maxresults");
        return maxresults != null ? new Integer(maxresults) : null;
    }

    public static class Builder {
        public static ListOptions includeMetadata() {
            ListOptions options = new ListOptions();
            return options.includeMetadata();
        }

        public static ListOptions prefix(String prefix) {
            ListOptions options = new ListOptions();
            return options.prefix(prefix);
        }

        public static ListOptions marker(String marker) {
            ListOptions options = new ListOptions();
            return options.marker(marker);
        }

        public static ListOptions maxResults(int maxKeys) {
            ListOptions options = new ListOptions();
            return options.maxResults(maxKeys);
        }
    }
}

