/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.blobstore.functions.AzureBlobToBlob;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.blobstore.binders.BindUserMetadataToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindAzureBlobMetadataToRequest
implements Binder {
    private final AzureBlobToBlob azureBlob2Blob;
    private final BindUserMetadataToHeadersWithPrefix blobBinder;

    @Inject
    public BindAzureBlobMetadataToRequest(AzureBlobToBlob azureBlob2Blob, BindUserMetadataToHeadersWithPrefix blobBinder) {
        this.azureBlob2Blob = Preconditions.checkNotNull(azureBlob2Blob, "azureBlob2Blob");
        this.blobBinder = Preconditions.checkNotNull(blobBinder, "blobBinder");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof AzureBlob, "this binder is only valid for AzureBlobs!");
        Preconditions.checkNotNull(request, "request");
        AzureBlob blob = (AzureBlob)AzureBlob.class.cast(input);
        Preconditions.checkArgument(blob.getPayload().getContentMetadata().getContentLength() != null && blob.getPayload().getContentMetadata().getContentLength() >= 0L, "size must be set");
        ImmutableMap.Builder<String, String> headers = ImmutableMap.builder();
        headers.put("x-ms-blob-type", blob.getProperties().getType().toString());
        switch (blob.getProperties().getType()) {
            case PAGE_BLOB: {
                headers.put("Content-Length", "0");
                headers.put("x-ms-blob-content-length", blob.getPayload().getContentMetadata().getContentLength().toString());
                break;
            }
            case BLOCK_BLOB: {
                Preconditions.checkArgument(Preconditions.checkNotNull(blob.getPayload().getContentMetadata().getContentLength(), "blob.getContentLength()") <= 0x4000000L, "maximum size for put Blob is 64MB");
            }
        }
        request = ModifyRequest.putHeaders(request, Multimaps.forMap(headers.build()));
        return this.blobBinder.bindToRequest(request, this.azureBlob2Blob.apply(blob));
    }
}

