/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.config;

import org.jclouds.azure.storage.config.AzureStorageRestClientModule;
import org.jclouds.azureblob.AzureBlobAsyncClient;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.config.AzureBlobModule;
import org.jclouds.azureblob.handlers.ParseAzureBlobErrorFromXmlContent;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresRestClient;

@ConfiguresRestClient
@RequiresHttp
public class AzureBlobRestClientModule
extends AzureStorageRestClientModule<AzureBlobClient, AzureBlobAsyncClient> {
    public AzureBlobRestClientModule() {
        super(AzureBlobClient.class, AzureBlobAsyncClient.class);
    }

    @Override
    protected void configure() {
        this.install(new AzureBlobModule());
        super.configure();
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseAzureBlobErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseAzureBlobErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseAzureBlobErrorFromXmlContent.class);
    }
}

