/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.xml;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.BlobType;
import org.jclouds.azureblob.domain.LeaseStatus;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.internal.BlobPropertiesImpl;
import org.jclouds.azureblob.domain.internal.HashSetListBlobsResponse;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ContainerNameEnumerationResultsHandler
extends ParseSax.HandlerWithResult<ListBlobsResponse> {
    private Set<BlobProperties> blobMetadata = Sets.newLinkedHashSet();
    private String prefix;
    private String marker;
    private int maxResults;
    private String nextMarker;
    private URI currentUrl;
    private URI containerUrl;
    private Date currentLastModified;
    private String currentETag;
    private StringBuilder currentText = new StringBuilder();
    private final DateService dateParser;
    private String delimiter;
    private String currentName;
    private long currentSize;
    private String currentContentType;
    private String currentContentEncoding;
    private String currentContentLanguage;
    private BlobType currentBlobType;
    private boolean inBlob;
    private boolean inBlobPrefix;
    private boolean inMetadata;
    private Set<String> blobPrefixes = Sets.newHashSet();
    private byte[] currentContentMD5;
    private Map<String, String> currentMetadata = Maps.newHashMap();
    private LeaseStatus currentLeaseStatus;

    @Inject
    public ContainerNameEnumerationResultsHandler(DateService dateParser) {
        this.dateParser = dateParser;
    }

    @Override
    public ListBlobsResponse getResult() {
        return new HashSetListBlobsResponse(this.blobMetadata, this.containerUrl, this.prefix, this.marker, this.maxResults, this.nextMarker, this.delimiter, this.blobPrefixes);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("Blob")) {
            this.inBlob = true;
            this.inBlobPrefix = false;
            this.inMetadata = false;
        } else if (qName.equals("BlobPrefix")) {
            this.inBlob = false;
            this.inBlobPrefix = true;
        } else if (qName.equals("Metadata")) {
            this.inBlob = true;
            this.inMetadata = true;
        } else if (qName.equals("EnumerationResults")) {
            this.containerUrl = URI.create(attributes.getValue("ContainerName").toString().trim());
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.inMetadata && !qName.equals("Metadata")) {
            this.currentMetadata.put(qName, this.currentText.toString().trim());
        } else if (qName.equals("Metadata")) {
            this.inMetadata = false;
        } else if (qName.equals("MaxResults")) {
            this.maxResults = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equals("Marker")) {
            this.marker = this.currentText.toString().trim();
            this.marker = this.marker.equals("") ? null : this.marker;
        } else if (qName.equals("Prefix")) {
            this.prefix = this.currentText.toString().trim();
            this.prefix = this.prefix.equals("") ? null : this.prefix;
        } else if (qName.equals("Delimiter")) {
            this.delimiter = this.currentText.toString().trim();
            this.delimiter = this.delimiter.equals("") ? null : this.delimiter;
        } else if (qName.equals("NextMarker")) {
            this.nextMarker = this.currentText.toString().trim();
            this.nextMarker = this.nextMarker.equals("") ? null : this.nextMarker;
        } else if (qName.equals("BlobType")) {
            this.currentBlobType = BlobType.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("LeaseStatus")) {
            this.currentLeaseStatus = LeaseStatus.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("Blob")) {
            BlobPropertiesImpl md = new BlobPropertiesImpl(this.currentBlobType, this.currentName, this.containerUrl.getPath().replace("/", ""), this.currentUrl, this.currentLastModified, this.currentETag, this.currentSize, this.currentContentType, this.currentContentMD5, this.currentContentEncoding, this.currentContentLanguage, this.currentLeaseStatus, this.currentMetadata);
            this.blobMetadata.add(md);
            this.currentBlobType = null;
            this.currentName = null;
            this.currentUrl = null;
            this.currentLastModified = null;
            this.currentETag = null;
            this.currentSize = -1L;
            this.currentContentType = null;
            this.currentContentEncoding = null;
            this.currentContentLanguage = null;
            this.currentContentMD5 = null;
            this.currentLeaseStatus = null;
            this.currentMetadata = Maps.newHashMap();
        } else if (qName.equals("Url")) {
            this.currentUrl = HttpUtils.createUri(this.currentText.toString().trim());
        } else if (qName.equals("Last-Modified")) {
            this.currentLastModified = this.dateParser.rfc822DateParse(this.currentText.toString().trim());
        } else if (qName.equals("Etag")) {
            this.currentETag = this.currentText.toString().trim();
        } else if (qName.equals("Name")) {
            if (this.inBlob) {
                this.currentName = this.currentText.toString().trim();
            } else if (this.inBlobPrefix) {
                this.blobPrefixes.add(this.currentText.toString().trim());
            }
        } else if (qName.equals("Content-Length")) {
            this.currentSize = Long.parseLong(this.currentText.toString().trim());
        } else if (qName.equals("Content-MD5")) {
            if (!this.currentText.toString().trim().equals("")) {
                this.currentContentMD5 = CryptoStreams.base64(this.currentText.toString().trim());
            }
        } else if (qName.equals("Content-Type")) {
            this.currentContentType = this.currentText.toString().trim();
        } else if (qName.equals("Content-Encoding")) {
            this.currentContentEncoding = this.currentText.toString().trim();
            if (this.currentContentEncoding.equals("")) {
                this.currentContentEncoding = null;
            }
        } else if (qName.equals("Content-Language")) {
            this.currentContentLanguage = this.currentText.toString().trim();
            if (this.currentContentLanguage.equals("")) {
                this.currentContentLanguage = null;
            }
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

