/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.MutableStorageMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.HttpGetOptionsListToGetOptions;
import org.jclouds.blobstore.internal.BaseAsyncBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.DateService;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.DelegatingPayload;
import org.jclouds.javax.annotation.Nullable;

public class TransientAsyncBlobStore
extends BaseAsyncBlobStore {
    protected final DateService dateService;
    protected final Crypto crypto;
    protected final ConcurrentMap<String, ConcurrentMap<String, Blob>> containerToBlobs;
    protected final Provider<UriBuilder> uriBuilders;
    protected final ConcurrentMap<String, Location> containerToLocation;
    protected final HttpGetOptionsListToGetOptions httpGetOptionsConverter;
    protected final IfDirectoryReturnNameStrategy ifDirectoryReturnName;
    protected final Blob.Factory blobFactory;

    @Inject
    protected TransientAsyncBlobStore(BlobStoreContext context, DateService dateService, Crypto crypto, ConcurrentMap<String, ConcurrentMap<String, Blob>> containerToBlobs, Provider<UriBuilder> uriBuilders, ConcurrentMap<String, Location> containerToLocation, HttpGetOptionsListToGetOptions httpGetOptionsConverter, IfDirectoryReturnNameStrategy ifDirectoryReturnName, Blob.Factory blobFactory, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ExecutorService service, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations) {
        super(context, blobUtils, service, defaultLocation, locations);
        this.blobFactory = blobFactory;
        this.dateService = dateService;
        this.crypto = crypto;
        this.containerToBlobs = containerToBlobs;
        this.uriBuilders = uriBuilders;
        this.containerToLocation = containerToLocation;
        this.httpGetOptionsConverter = httpGetOptionsConverter;
        this.ifDirectoryReturnName = ifDirectoryReturnName;
        this.getContainerToLocation().put("stub", defaultLocation.get());
        this.getContainerToBlobs().put("stub", new ConcurrentHashMap());
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list(final String container, ListContainerOptions options) {
        String delimiter;
        String prefix;
        final Map realContents = (Map)this.getContainerToBlobs().get(container);
        if (realContents == null) {
            return Futures.immediateFailedFuture(this.cnfe(container));
        }
        SortedSet<StorageMetadata> contents = Sets.newTreeSet(Iterables.transform(realContents.keySet(), new Function<String, StorageMetadata>(){

            @Override
            public StorageMetadata apply(String key) {
                Blob oldBlob = (Blob)realContents.get(key);
                Preconditions.checkState(oldBlob != null, "blob " + key + " is not present although it was in the list of " + container);
                Preconditions.checkState(oldBlob.getMetadata() != null, "blob " + container + "/" + key + " has no metadata");
                MutableBlobMetadata md = TransientAsyncBlobStore.copy(oldBlob.getMetadata());
                String directoryName = TransientAsyncBlobStore.this.ifDirectoryReturnName.execute(md);
                if (directoryName != null) {
                    md.setName(directoryName);
                    md.setType(StorageType.RELATIVE_PATH);
                }
                return md;
            }
        }));
        if (options.getMarker() != null) {
            final String finalMarker = options.getMarker();
            StorageMetadata lastMarkerMetadata = Iterables.find(contents, new Predicate<StorageMetadata>(){

                @Override
                public boolean apply(StorageMetadata metadata) {
                    return metadata.getName().equals(finalMarker);
                }
            });
            contents = contents.tailSet(lastMarkerMetadata);
            contents.remove(lastMarkerMetadata);
        }
        if ((prefix = options.getDir()) != null) {
            contents = Sets.newTreeSet(Sets.filter(contents, new Predicate<StorageMetadata>(){

                @Override
                public boolean apply(StorageMetadata o) {
                    return o != null && o.getName().startsWith(prefix) && !o.getName().equals(prefix);
                }
            }));
        }
        String marker = null;
        Integer maxResults = options.getMaxResults() != null ? options.getMaxResults() : 1000;
        if (contents.size() > 0) {
            SortedSet<StorageMetadata> contentsSlice = TransientAsyncBlobStore.firstSliceOfSize(contents, maxResults);
            marker = !contentsSlice.contains(contents.last()) ? contentsSlice.last().getName() : null;
            contents = contentsSlice;
        }
        String string = delimiter = options.isRecursive() ? null : "/";
        if (delimiter != null) {
            TreeSet commonPrefixes = null;
            Iterable<String> iterable = Iterables.transform(contents, new CommonPrefixes(prefix != null ? prefix : null, delimiter));
            commonPrefixes = iterable != null ? Sets.newTreeSet(iterable) : new TreeSet();
            commonPrefixes.remove("NO_PREFIX");
            contents = Sets.newTreeSet(Sets.filter(contents, new DelimiterFilter(prefix != null ? prefix : null, delimiter)));
            Iterables.addAll(contents, Iterables.transform(commonPrefixes, new Function<String, StorageMetadata>(){

                @Override
                public StorageMetadata apply(String o) {
                    MutableStorageMetadataImpl md = new MutableStorageMetadataImpl();
                    md.setType(StorageType.RELATIVE_PATH);
                    md.setName(o);
                    return md;
                }
            }));
        }
        if (!options.isDetailed()) {
            for (StorageMetadata md : contents) {
                md.getUserMetadata().clear();
            }
        }
        return Futures.immediateFuture(new PageSetImpl<StorageMetadata>(contents, marker));
    }

    private ContainerNotFoundException cnfe(String name) {
        return new ContainerNotFoundException(name, String.format("container %s not in %s", name, this.getContainerToBlobs().keySet()));
    }

    public static MutableBlobMetadata copy(MutableBlobMetadata in) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bout);
            os.writeObject(in);
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
            MutableBlobMetadata out = (MutableBlobMetadata)is.readObject();
            TransientAsyncBlobStore.convertUserMetadataKeysToLowercase(out);
            HttpUtils.copy(in.getContentMetadata(), out.getContentMetadata());
            return out;
        }
        catch (Exception e) {
            Throwables.propagate(e);
            assert (false) : "exception should have propagated: " + e;
            return null;
        }
    }

    private static void convertUserMetadataKeysToLowercase(MutableBlobMetadata metadata) {
        HashMap<String, String> lowerCaseUserMetadata = Maps.newHashMap();
        for (Map.Entry<String, String> entry : metadata.getUserMetadata().entrySet()) {
            lowerCaseUserMetadata.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        metadata.setUserMetadata(lowerCaseUserMetadata);
    }

    public static MutableBlobMetadata copy(MutableBlobMetadata in, String newKey) {
        MutableBlobMetadata newMd = TransientAsyncBlobStore.copy(in);
        newMd.setName(newKey);
        return newMd;
    }

    @Override
    public ListenableFuture<Void> removeBlob(String container, String key) {
        if (this.getContainerToBlobs().containsKey(container)) {
            ((ConcurrentMap)this.getContainerToBlobs().get(container)).remove(key);
        }
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Blob> removeBlobAndReturnOld(String container, String key) {
        if (this.getContainerToBlobs().containsKey(container)) {
            return Futures.immediateFuture(((ConcurrentMap)this.getContainerToBlobs().get(container)).remove(key));
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public ListenableFuture<Void> clearContainer(String container) {
        ((ConcurrentMap)this.getContainerToBlobs().get(container)).clear();
        return Futures.immediateFuture(null);
    }

    @Override
    public ListenableFuture<Void> deleteContainer(String container) {
        if (this.getContainerToBlobs().containsKey(container)) {
            this.getContainerToBlobs().remove(container);
        }
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Boolean> deleteContainerImpl(String container) {
        Boolean returnVal = true;
        if (this.getContainerToBlobs().containsKey(container)) {
            if (((ConcurrentMap)this.getContainerToBlobs().get(container)).size() == 0) {
                this.getContainerToBlobs().remove(container);
            } else {
                returnVal = false;
            }
        }
        return Futures.immediateFuture(returnVal);
    }

    @Override
    public ListenableFuture<Boolean> containerExists(String container) {
        return Futures.immediateFuture(this.getContainerToBlobs().containsKey(container));
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list() {
        return Futures.immediateFuture(new PageSetImpl<StorageMetadata>(Iterables.transform(this.getContainerToBlobs().keySet(), new Function<String, StorageMetadata>(){

            @Override
            public StorageMetadata apply(String name) {
                MutableStorageMetadata cmd = TransientAsyncBlobStore.this.create();
                cmd.setName(name);
                cmd.setType(StorageType.CONTAINER);
                cmd.setLocation((Location)TransientAsyncBlobStore.this.getContainerToLocation().get(name));
                return cmd;
            }
        }), null));
    }

    protected MutableStorageMetadata create() {
        return new MutableStorageMetadataImpl();
    }

    @Override
    public ListenableFuture<Boolean> createContainerInLocation(Location location, String name) {
        if (this.getContainerToBlobs().containsKey(name)) {
            return Futures.immediateFuture(Boolean.FALSE);
        }
        this.getContainerToBlobs().put(name, new ConcurrentHashMap());
        this.getContainerToLocation().put(name, location != null ? location : (Location)this.defaultLocation.get());
        return Futures.immediateFuture(Boolean.TRUE);
    }

    public ListenableFuture<Void> createContainerInLocationIfAbsent(Location location, String name) {
        ConcurrentMap container = this.getContainerToBlobs().putIfAbsent(name, new ConcurrentHashMap());
        if (container == null) {
            this.getContainerToLocation().put(name, location != null ? location : (Location)this.defaultLocation.get());
            return Futures.immediateFuture(null);
        }
        return Futures.immediateFailedFuture(new IllegalStateException("container " + name + " already exists"));
    }

    public String getFirstQueryOrNull(String string, @Nullable HttpRequestOptions options) {
        if (options == null) {
            return null;
        }
        Collection<String> values = options.buildQueryParameters().get(string);
        return values != null && values.size() >= 1 ? values.iterator().next() : null;
    }

    public static <T extends Comparable<?>> SortedSet<T> firstSliceOfSize(Iterable<T> elements, int size) {
        List<List<T>> slices = Lists.partition(Lists.newArrayList(elements), size);
        return Sets.newTreeSet((Iterable)slices.get(0));
    }

    public static HttpResponseException returnResponseException(int code) {
        HttpResponse response = null;
        response = new HttpResponse(code, null, null);
        return new HttpResponseException(new HttpCommand(){

            @Override
            public int getRedirectCount() {
                return 0;
            }

            @Override
            public int incrementRedirectCount() {
                return 0;
            }

            @Override
            public boolean isReplayable() {
                return false;
            }

            @Override
            public Exception getException() {
                return null;
            }

            @Override
            public int getFailureCount() {
                return 0;
            }

            @Override
            public HttpRequest getCurrentRequest() {
                return new HttpRequest("GET", URI.create("http://stub"));
            }

            @Override
            public int incrementFailureCount() {
                return 0;
            }

            @Override
            public void setException(Exception exception) {
            }

            @Override
            public void setCurrentRequest(HttpRequest request) {
            }
        }, response);
    }

    @Override
    public ListenableFuture<String> putBlob(String containerName, Blob in) {
        Preconditions.checkArgument(containerName != null, "containerName must be set");
        Preconditions.checkArgument(in != null, "blob must be set");
        ConcurrentMap container = (ConcurrentMap)this.getContainerToBlobs().get(containerName);
        if (container == null) {
            return Futures.immediateFailedFuture(new IllegalStateException("containerName not found: " + containerName));
        }
        Blob blob = this.createUpdatedCopyOfBlobInContainer(containerName, in);
        container.put(blob.getMetadata().getName(), blob);
        return Futures.immediateFuture(Iterables.getOnlyElement(blob.getAllHeaders().get("ETag")));
    }

    public ListenableFuture<Blob> putBlobAndReturnOld(String containerName, Blob in) {
        ConcurrentMap container = (ConcurrentMap)this.getContainerToBlobs().get(containerName);
        if (container == null) {
            return Futures.immediateFailedFuture(new IllegalStateException("containerName not found: " + containerName));
        }
        Blob blob = this.createUpdatedCopyOfBlobInContainer(containerName, in);
        Blob old = container.put(blob.getMetadata().getName(), blob);
        return Futures.immediateFuture(old);
    }

    protected Blob createUpdatedCopyOfBlobInContainer(String containerName, Blob in) {
        ByteArrayPayload payload;
        Preconditions.checkNotNull(in, "blob");
        Preconditions.checkNotNull(in.getPayload(), "blob.payload");
        ByteArrayPayload byteArrayPayload = payload = in.getPayload() instanceof ByteArrayPayload ? (ByteArrayPayload)ByteArrayPayload.class.cast(in.getPayload()) : null;
        if (payload == null) {
            payload = in.getPayload() instanceof DelegatingPayload ? (((DelegatingPayload)DelegatingPayload.class.cast(in.getPayload())).getDelegate() instanceof ByteArrayPayload ? (ByteArrayPayload)ByteArrayPayload.class.cast(((DelegatingPayload)DelegatingPayload.class.cast(in.getPayload())).getDelegate()) : null) : null;
        }
        try {
            if (payload == null || !(payload instanceof ByteArrayPayload)) {
                MutableContentMetadata oldMd = in.getPayload().getContentMetadata();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                in.getPayload().writeTo(out);
                payload = (ByteArrayPayload)Payloads.calculateMD5(Payloads.newPayload(out.toByteArray()));
                HttpUtils.copy(oldMd, payload.getContentMetadata());
            } else if (payload.getContentMetadata().getContentMD5() == null) {
                Payloads.calculateMD5(in, this.crypto.md5());
            }
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
        Blob blob = this.blobFactory.create(TransientAsyncBlobStore.copy(in.getMetadata()));
        blob.setPayload(payload);
        blob.getMetadata().setContainer(containerName);
        blob.getMetadata().setUri(this.uriBuilders.get().scheme("mem").host(containerName).path(in.getMetadata().getName()).build(new Object[0]));
        blob.getMetadata().setLastModified(new Date());
        String eTag = CryptoStreams.hex(payload.getContentMetadata().getContentMD5());
        blob.getMetadata().setETag(eTag);
        blob.getAllHeaders().replaceValues("Last-Modified", Collections.singleton(this.dateService.rfc822DateFormat(blob.getMetadata().getLastModified())));
        blob.getAllHeaders().replaceValues("ETag", Collections.singleton(eTag));
        this.copyPayloadHeadersToBlob(payload, blob);
        blob.getAllHeaders().putAll(Multimaps.forMap(blob.getMetadata().getUserMetadata()));
        return blob;
    }

    private void copyPayloadHeadersToBlob(Payload payload, Blob blob) {
        blob.getAllHeaders().putAll(HttpUtils.getContentHeadersFromMetadata(payload.getContentMetadata()));
    }

    @Override
    public ListenableFuture<Boolean> blobExists(String containerName, String key) {
        if (!this.getContainerToBlobs().containsKey(containerName)) {
            return Futures.immediateFailedFuture(this.cnfe(containerName));
        }
        Map realContents = (Map)this.getContainerToBlobs().get(containerName);
        return Futures.immediateFuture(realContents.containsKey(key));
    }

    @Override
    public ListenableFuture<Blob> getBlob(String containerName, String key, GetOptions options) {
        if (!this.getContainerToBlobs().containsKey(containerName)) {
            return Futures.immediateFailedFuture(this.cnfe(containerName));
        }
        Map realContents = (Map)this.getContainerToBlobs().get(containerName);
        if (!realContents.containsKey(key)) {
            return Futures.immediateFuture(null);
        }
        Blob object = (Blob)realContents.get(key);
        if (options.getIfMatch() != null && !object.getMetadata().getETag().equals(options.getIfMatch())) {
            return Futures.immediateFailedFuture(TransientAsyncBlobStore.returnResponseException(412));
        }
        if (options.getIfNoneMatch() != null && object.getMetadata().getETag().equals(options.getIfNoneMatch())) {
            return Futures.immediateFailedFuture(TransientAsyncBlobStore.returnResponseException(304));
        }
        if (options.getIfModifiedSince() != null) {
            Date modifiedSince = options.getIfModifiedSince();
            if (object.getMetadata().getLastModified().before(modifiedSince)) {
                HttpResponse response = new HttpResponse(304, null, null);
                return Futures.immediateFailedFuture(new HttpResponseException(String.format("%1$s is before %2$s", object.getMetadata().getLastModified(), modifiedSince), null, response));
            }
        }
        if (options.getIfUnmodifiedSince() != null) {
            Date unmodifiedSince = options.getIfUnmodifiedSince();
            if (object.getMetadata().getLastModified().after(unmodifiedSince)) {
                HttpResponse response = new HttpResponse(412, null, null);
                return Futures.immediateFailedFuture(new HttpResponseException(String.format("%1$s is after %2$s", object.getMetadata().getLastModified(), unmodifiedSince), null, response));
            }
        }
        Blob returnVal = this.copyBlob(object);
        if (options.getRanges() != null && options.getRanges().size() > 0) {
            byte[] data;
            try {
                data = ByteStreams.toByteArray(returnVal.getPayload().getInput());
            }
            catch (IOException e) {
                return Futures.immediateFailedFuture(new RuntimeException(e));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (String s : options.getRanges()) {
                if (s.startsWith("-")) {
                    int length = Integer.parseInt(s.substring(1));
                    out.write(data, data.length - length, length);
                    continue;
                }
                if (s.endsWith("-")) {
                    int offset = Integer.parseInt(s.substring(0, s.length() - 1));
                    out.write(data, offset, data.length - offset);
                    continue;
                }
                if (s.contains("-")) {
                    String[] firstLast = s.split("\\-");
                    int offset = Integer.parseInt(firstLast[0]);
                    int last = Integer.parseInt(firstLast[1]);
                    int length = last < data.length ? last + 1 : data.length - offset;
                    out.write(data, offset, length);
                    continue;
                }
                return Futures.immediateFailedFuture(new IllegalArgumentException("first and last were null!"));
            }
            MutableContentMetadata cmd = returnVal.getPayload().getContentMetadata();
            returnVal.setPayload(out.toByteArray());
            HttpUtils.copy(cmd, returnVal.getPayload().getContentMetadata());
            returnVal.getPayload().getContentMetadata().setContentLength(new Long(out.toByteArray().length));
        }
        Preconditions.checkNotNull(returnVal.getPayload(), "payload " + returnVal);
        return Futures.immediateFuture(returnVal);
    }

    @Override
    public ListenableFuture<BlobMetadata> blobMetadata(String container, String key) {
        try {
            Blob blob = (Blob)this.getBlob(container, key).get();
            return Futures.immediateFuture(blob != null ? TransientAsyncBlobStore.copy(blob.getMetadata()) : null);
        }
        catch (Exception e) {
            if (Iterables.size(Iterables.filter(Throwables.getCausalChain(e), KeyNotFoundException.class)) >= 1) {
                return Futures.immediateFuture(null);
            }
            return Futures.immediateFailedFuture(e);
        }
    }

    private Blob copyBlob(Blob blob) {
        Blob returnVal = this.blobFactory.create(TransientAsyncBlobStore.copy(blob.getMetadata()));
        returnVal.setPayload(blob.getPayload());
        this.copyPayloadHeadersToBlob(blob.getPayload(), returnVal);
        return returnVal;
    }

    public ConcurrentMap<String, ConcurrentMap<String, Blob>> getContainerToBlobs() {
        return this.containerToBlobs;
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        this.getContainerToBlobs().remove(container);
        return this.getContainerToBlobs().containsKey(container);
    }

    public ConcurrentMap<String, Location> getContainerToLocation() {
        return this.containerToLocation;
    }

    @Override
    public ListenableFuture<String> putBlob(String container, Blob blob, PutOptions options) {
        return this.putBlob(container, blob);
    }

    @Override
    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if (options.isPublicRead()) {
            throw new UnsupportedOperationException("publicRead");
        }
        return this.createContainerInLocation(location, container);
    }

    protected static class CommonPrefixes
    implements Function<StorageMetadata, String> {
        private final String prefix;
        private final String delimiter;
        public static final String NO_PREFIX = "NO_PREFIX";

        public CommonPrefixes(String prefix, String delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        @Override
        public String apply(StorageMetadata metadata) {
            String working = metadata.getName();
            if (this.prefix != null) {
                String toMatch;
                String string = toMatch = this.prefix.endsWith("/") ? this.prefix : this.prefix + this.delimiter;
                if (working.startsWith(toMatch)) {
                    working = working.replaceFirst(toMatch, "");
                }
            }
            if (working.contains(this.delimiter)) {
                return working.substring(0, working.indexOf(this.delimiter));
            }
            return NO_PREFIX;
        }
    }

    protected static class DelimiterFilter
    implements Predicate<StorageMetadata> {
        private final String prefix;
        private final String delimiter;

        public DelimiterFilter(String prefix, String delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        @Override
        public boolean apply(StorageMetadata metadata) {
            String toMatch;
            if (this.prefix == null) {
                return metadata.getName().indexOf(this.delimiter) == -1;
            }
            String string = toMatch = this.prefix.endsWith("/") ? this.prefix : this.prefix + this.delimiter;
            if (metadata.getName().startsWith(toMatch)) {
                String unprefixedName = metadata.getName().replaceFirst(toMatch, "");
                if (unprefixedName.equals("")) {
                    return false;
                }
                return unprefixedName.indexOf(this.delimiter) == -1;
            }
            return false;
        }
    }
}

