/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.location.Provider;

@Singleton
public class TransientBlobRequestSigner
implements BlobRequestSigner {
    private final BasicAuthentication basicAuth;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final String endpoint;

    @Inject
    public TransientBlobRequestSigner(BasicAuthentication basicAuth, BlobToHttpGetOptions blob2HttpGetOptions, @Provider URI endpoint) {
        this.basicAuth = Preconditions.checkNotNull(basicAuth, "basicAuth");
        this.blob2HttpGetOptions = Preconditions.checkNotNull(blob2HttpGetOptions, "blob2HttpGetOptions");
        this.endpoint = endpoint.toString();
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        HttpRequest request = new HttpRequest("GET", URI.create(String.format("%s/%s/%s", this.endpoint, container, name)));
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint(URI.create(String.format("%s/%s/%s", this.endpoint, container, blob.getMetadata().getName()))).payload(blob.getPayload()).headers((Multimap)HttpUtils.getContentHeadersFromMetadata(blob.getMetadata().getContentMetadata()))).build();
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signRemoveBlob(String container, String name) {
        HttpRequest request = new HttpRequest("DELETE", URI.create(String.format("%s/%s/%s", this.endpoint, container, name)));
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, GetOptions options) {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create(String.format("%s/%s/%s", this.endpoint, container, name))).headers((Multimap)this.blob2HttpGetOptions.apply(options).buildRequestHeaders())).build();
        return this.basicAuth.filter(request);
    }
}

