/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.blobstore.BlobMap;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.internal.BaseBlobMap;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;
import org.jclouds.blobstore.strategy.GetBlobsInListStrategy;
import org.jclouds.blobstore.strategy.PutBlobsStrategy;
import org.jclouds.blobstore.strategy.internal.ListContainerAndRecurseThroughFolders;

public class BlobMapImpl
extends BaseBlobMap<Blob>
implements BlobMap {
    private final CorrectBlobName correctBlobName;
    private final Provider<BlobBuilder> blobBuilders;

    @Inject
    public BlobMapImpl(BlobStore blobstore, GetBlobsInListStrategy getAllBlobs, ContainsValueInListStrategy containsValueStrategy, PutBlobsStrategy putBlobsStrategy, ListContainerAndRecurseThroughFolders listStrategy, String containerName, ListContainerOptions options, Provider<BlobBuilder> blobBuilders) {
        super(blobstore, getAllBlobs, containsValueStrategy, putBlobsStrategy, listStrategy, containerName, options);
        this.correctBlobName = new CorrectBlobName(this.prefixer);
        this.blobBuilders = Preconditions.checkNotNull(blobBuilders, "blobBuilders");
    }

    @Override
    public Blob get(Object key) {
        String realKey = (String)this.prefixer.apply(Preconditions.checkNotNull(key, "key").toString());
        Blob blob = this.blobstore.getBlob(this.containerName, realKey);
        return blob != null ? this.stripPrefix(blob) : null;
    }

    @Override
    public Blob put(String key, Blob value) {
        Blob returnVal = this.getLastValue(Preconditions.checkNotNull(key, "key"));
        this.blobstore.putBlob(this.containerName, this.correctBlobName.apply(key, value));
        return returnVal;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Blob> map) {
        this.putBlobsStrategy.execute(this.containerName, Iterables.transform(Preconditions.checkNotNull(map, "map").entrySet(), this.correctBlobName));
    }

    @Override
    public Blob remove(Object key) {
        Blob old = this.getLastValue(Preconditions.checkNotNull(key, "key"));
        String realKey = (String)this.prefixer.apply(key.toString());
        this.blobstore.removeBlob(this.containerName, realKey);
        return old;
    }

    private Blob getLastValue(Object key) {
        Blob old;
        try {
            old = this.get(Preconditions.checkNotNull(key, "key"));
        }
        catch (KeyNotFoundException e) {
            old = null;
        }
        return old;
    }

    @Override
    public Collection<Blob> values() {
        return ImmutableSet.copyOf(this.getAllBlobs.execute(this.containerName, this.options));
    }

    @Override
    public BlobBuilder blobBuilder() {
        return this.blobBuilders.get();
    }

    public static class CorrectBlobName
    implements Function<Map.Entry<? extends String, ? extends Blob>, Blob> {
        private final Function<String, String> prefixer;

        public CorrectBlobName(Function<String, String> prefixer) {
            this.prefixer = Preconditions.checkNotNull(prefixer, "prefixer");
        }

        @Override
        public Blob apply(Map.Entry<? extends String, ? extends Blob> arg0) {
            return this.apply(arg0.getKey(), arg0.getValue());
        }

        public Blob apply(String key, Blob blob) {
            blob.getMetadata().setName(this.prefixer.apply(key));
            return blob;
        }
    }
}

