/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContextBuilder;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.BlobName;
import org.jclouds.functions.ExceptionToValueOrPropagate;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.Providers;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;

public class BlobStoreUtils {
    public static final ExceptionToValueOrPropagate<KeyNotFoundException, ?> keyNotFoundToNullOrPropagate = new ExceptionToValueOrPropagate<KeyNotFoundException, Object>(KeyNotFoundException.class, null);
    public static final ExceptionToValueOrPropagate<ContainerNotFoundException, ?> containerNotFoundToNullOrPropagate = new ExceptionToValueOrPropagate<ContainerNotFoundException, Object>(ContainerNotFoundException.class, null);
    private static Pattern keyFromContainer = Pattern.compile("/?[^/]+/(.*)");
    private static final BlobName blobName = new BlobName();

    public static <T> HttpRequest cleanRequest(HttpRequest returnVal) {
        Preconditions.checkNotNull(returnVal, "http request");
        for (HttpRequestFilter filter : returnVal.getFilters()) {
            returnVal = filter.filter(returnVal);
        }
        HttpRequest toReturn = new HttpRequest(returnVal.getMethod(), returnVal.getEndpoint(), ImmutableMultimap.copyOf(returnVal.getHeaders()));
        if (returnVal.getPayload() != null) {
            toReturn.setPayload(returnVal.getPayload());
        }
        return toReturn;
    }

    public static <T> T keyNotFoundToNullOrPropagate(Exception e) {
        return (T)keyNotFoundToNullOrPropagate.apply(e);
    }

    public static <T> T containerNotFoundToNullOrPropagate(Exception e) {
        return (T)containerNotFoundToNullOrPropagate.apply(e);
    }

    public static Blob newBlob(BlobStore blobStore, StorageMetadata blobMeta) {
        Blob blob = Preconditions.checkNotNull(blobStore, "blobStore").blobBuilder(Preconditions.checkNotNull(blobMeta, "blobMeta").getName()).userMetadata(blobMeta.getUserMetadata()).build();
        if (blobMeta instanceof BlobMetadata) {
            HttpUtils.copy(((BlobMetadata)blobMeta).getContentMetadata(), blob.getMetadata().getContentMetadata());
        }
        blob.getMetadata().setETag(blobMeta.getETag());
        blob.getMetadata().setId(blobMeta.getProviderId());
        blob.getMetadata().setLastModified(blobMeta.getLastModified());
        blob.getMetadata().setLocation(blobMeta.getLocation());
        blob.getMetadata().setUri(blobMeta.getUri());
        return blob;
    }

    public static String parseContainerFromPath(String path) {
        String container = Preconditions.checkNotNull(path, "path");
        if (path.indexOf(47) != -1) {
            container = path.substring(0, path.indexOf(47));
        }
        return container;
    }

    public static String parsePrefixFromPath(String path) {
        String prefix = null;
        if (Preconditions.checkNotNull(path, "path").indexOf(47) != -1) {
            prefix = path.substring(path.indexOf(47) + 1);
        }
        return "".equals(prefix) ? null : prefix;
    }

    public static String parseDirectoryFromPath(String path) {
        return Preconditions.checkNotNull(path, "path").substring(0, path.lastIndexOf(47));
    }

    public static String getNameFor(GeneratedHttpRequest<?> request) {
        Matcher matcher;
        Preconditions.checkNotNull(request, "request");
        if (request.getArgs().size() >= 2 && request.getArgs().get(0) instanceof String && request.getArgs().get(1) instanceof String) {
            return request.getArgs().get(1).toString();
        }
        if (request.getArgs().size() >= 1 && request.getArgs().get(0) instanceof String && (matcher = keyFromContainer.matcher(request.getArgs().get(0).toString())).find()) {
            return matcher.group(1);
        }
        String objectKey = request.getEndpoint().getPath();
        if (objectKey.startsWith("/")) {
            objectKey = objectKey.substring(1);
        }
        return objectKey;
    }

    public static String getContentAsStringOrNullAndClose(Blob blob) throws IOException {
        Preconditions.checkNotNull(blob, "blob");
        Preconditions.checkNotNull(blob.getPayload(), "blob.payload");
        if (blob.getPayload().getInput() == null) {
            return null;
        }
        InputStream o = blob.getPayload().getInput();
        if (o instanceof InputStream) {
            return Strings2.toStringAndClose(o);
        }
        throw new IllegalArgumentException("Object type not supported: " + o.getClass().getName());
    }

    public static ListenableFuture<Void> createParentIfNeededAsync(AsyncBlobStore asyncBlobStore, String container, Blob blob) {
        Preconditions.checkNotNull(asyncBlobStore, "asyncBlobStore");
        Preconditions.checkNotNull(container, "container");
        String name = blobName.apply(blob);
        if (name.indexOf(47) > 0) {
            return asyncBlobStore.createDirectory(container, BlobStoreUtils.parseDirectoryFromPath(name));
        }
        return Futures.immediateFuture(null);
    }

    public static Iterable<String> getSupportedProviders() {
        return Providers.getSupportedProvidersOfType(BlobStoreContextBuilder.class);
    }
}

