/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import java.util.List;
import java.util.Properties;
import org.jclouds.byon.config.BYONComputeServiceContextModule;
import org.jclouds.byon.config.ConfiguresNodeStore;
import org.jclouds.byon.config.YamlNodeStoreModule;
import org.jclouds.compute.StandaloneComputeServiceContextBuilder;

public class BYONComputeServiceContextBuilder
extends StandaloneComputeServiceContextBuilder<Supplier> {
    public BYONComputeServiceContextBuilder(Properties props) {
        super(Supplier.class, props);
    }

    @Override
    protected void addContextModule(List<Module> modules) {
        modules.add(new BYONComputeServiceContextModule());
        this.addNodeStoreModuleIfNotPresent(modules);
    }

    protected void addNodeStoreModuleIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresNodeStore.class);
            }
        })) {
            this.addNodeStoreModule(modules);
        }
    }

    protected void addNodeStoreModule(List<Module> modules) {
        modules.add(new YamlNodeStoreModule());
    }
}

