/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.InputSupplier;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.jclouds.byon.config.ConfiguresNodeStore;
import org.jclouds.byon.domain.YamlNode;
import org.jclouds.byon.functions.NodesFromYamlStream;
import org.jclouds.byon.suppliers.NodesParsedFromSupplier;
import org.jclouds.collect.TransformingMap;
import org.jclouds.io.CopyInputStreamInputSupplierMap;
import org.jclouds.io.CopyInputStreamIntoSupplier;

@ConfiguresNodeStore
@Beta
public class YamlNodeStoreModule
extends AbstractModule {
    private static final Map<String, InputSupplier<InputStream>> BACKING = new ConcurrentHashMap<String, InputSupplier<InputStream>>();
    private final Map<String, InputStream> backing;

    public YamlNodeStoreModule(Map<String, InputStream> backing) {
        this.backing = backing;
    }

    public YamlNodeStoreModule() {
        this(null);
    }

    @Override
    protected void configure() {
        this.bind(new TypeLiteral<Supplier<LoadingCache<String, Node>>>(){}).to(NodesParsedFromSupplier.class);
        this.bind(new TypeLiteral<Function<InputStream, LoadingCache<String, Node>>>(){}).to(NodesFromYamlStream.class);
        this.bind(new TypeLiteral<Function<YamlNode, InputStream>>(){}).toInstance(YamlNode.yamlNodeToInputStream);
        this.bind(new TypeLiteral<Function<InputStream, YamlNode>>(){}).toInstance(YamlNode.inputStreamToYamlNode);
        this.bind(new TypeLiteral<Function<Node, YamlNode>>(){}).toInstance(YamlNode.nodeToYamlNode);
        this.bind(new TypeLiteral<Function<YamlNode, Node>>(){}).toInstance(YamlNode.toNode);
        if (this.backing != null) {
            this.bind(new TypeLiteral<Map<String, InputStream>>(){}).annotatedWith(Names.named("yaml")).toInstance(this.backing);
        } else {
            this.bind(new TypeLiteral<Map<String, InputSupplier<InputStream>>>(){}).annotatedWith(Names.named("yaml")).toInstance(BACKING);
            this.bind(new TypeLiteral<Map<String, InputStream>>(){}).annotatedWith(Names.named("yaml")).to((TypeLiteral<Map<String, InputStream>>)new TypeLiteral<YAMLCopyInputStreamInputSupplierMap>(){});
        }
    }

    @Provides
    @Singleton
    protected LoadingCache<String, Node> provideNodeStore(Map<String, YamlNode> backing, Function<Node, YamlNode> yamlSerializer, Function<YamlNode, Node> yamlDeserializer) {
        return CacheBuilder.newBuilder().build(CacheLoader.from(Functions.forMap(new TransformingMap<String, YamlNode, Node>(backing, yamlDeserializer, yamlSerializer))));
    }

    @Provides
    @Singleton
    protected Map<String, YamlNode> provideYamlStore(@Named(value="yaml") Map<String, InputStream> backing, Function<YamlNode, InputStream> yamlSerializer, Function<InputStream, YamlNode> yamlDeserializer) {
        return new TransformingMap<String, InputStream, YamlNode>(backing, yamlDeserializer, yamlSerializer);
    }

    @Singleton
    public static class YAMLCopyInputStreamInputSupplierMap
    extends CopyInputStreamInputSupplierMap {
        @Inject
        public YAMLCopyInputStreamInputSupplierMap(@Named(value="yaml") Map<String, InputSupplier<InputStream>> toMap, CopyInputStreamIntoSupplier putFunction) {
            super(toMap, putFunction);
        }
    }
}

