/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.config;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudloadbalancers.CloudLoadBalancersAsyncClient;
import org.jclouds.cloudloadbalancers.CloudLoadBalancersClient;
import org.jclouds.cloudloadbalancers.features.LoadBalancerAsyncClient;
import org.jclouds.cloudloadbalancers.features.LoadBalancerClient;
import org.jclouds.cloudloadbalancers.features.NodeAsyncClient;
import org.jclouds.cloudloadbalancers.features.NodeClient;
import org.jclouds.cloudloadbalancers.functions.ConvertLB;
import org.jclouds.cloudloadbalancers.handlers.ParseCloudLoadBalancersErrorFromHttpResponse;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;
import org.jclouds.location.config.ProvideRegionToURIViaProperties;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.OpenStackAuthAsyncClient;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.handlers.RetryOnRenew;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@RequiresHttp
@ConfiguresRestClient
public class CloudLoadBalancersRestClientModule
extends RestClientModule<CloudLoadBalancersClient, CloudLoadBalancersAsyncClient> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(LoadBalancerClient.class, LoadBalancerAsyncClient.class).put(NodeClient.class, NodeAsyncClient.class).build();

    public CloudLoadBalancersRestClientModule() {
        super(CloudLoadBalancersClient.class, CloudLoadBalancersAsyncClient.class, DELEGATE_MAP);
    }

    protected void bindRegionsToProvider() {
        this.bindRegionsToProvider(ProvideRegionToURIViaPropertiesWithAccountID.class);
    }

    protected void bindRegionsToProvider(Class<? extends javax.inject.Provider<Map<String, URI>>> providerClass) {
        this.bind(new TypeLiteral<Map<String, URI>>(){}).annotatedWith(Region.class).toProvider(providerClass).in(Scopes.SINGLETON);
    }

    @Override
    protected void configure() {
        this.install(new OpenStackAuthenticationModule());
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.bindRegionsToProvider();
        this.install(new FactoryModuleBuilder().build(ConvertLB.Factory.class));
        super.configure();
    }

    @Provides
    @Singleton
    @Named(value="jclouds.rackspace.account-id")
    protected String accountID(Supplier<OpenStackAuthAsyncClient.AuthenticationResponse> in) {
        URI serverURL = in.get().getServices().get("X-Server-Management-Url");
        return serverURL.getPath().substring(serverURL.getPath().lastIndexOf(47) + 1);
    }

    @Provides
    @Singleton
    @Region
    public Set<String> regions(@Region Map<String, URI> endpoints) {
        return endpoints.keySet();
    }

    @Provides
    @Singleton
    @Nullable
    @Region
    protected String getDefaultRegion(@Provider URI uri, @Region Map<String, URI> map, Logger.LoggerFactory logFactory) {
        String region = (String)((ImmutableBiMap)ImmutableBiMap.copyOf(map).inverse()).get(uri);
        if (region == null && map.size() > 0) {
            logFactory.getLogger(this.getClass().getName()).warn("failed to find region for current endpoint %s in %s; choosing first: %s", uri, map, region);
            region = Iterables.get(map.keySet(), 0);
        }
        return region;
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseCloudLoadBalancersErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseCloudLoadBalancersErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseCloudLoadBalancersErrorFromHttpResponse.class);
    }

    @Override
    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
    }

    @Singleton
    public static class ProvideRegionToURIViaPropertiesWithAccountID
    extends ProvideRegionToURIViaProperties {
        @Inject
        protected ProvideRegionToURIViaPropertiesWithAccountID(Injector injector, @Named(value="CONSTANTS") Multimap<String, String> constants, @Named(value="jclouds.rackspace.account-id") String accountID) {
            super(injector, constants);
            constants.replaceValues("jclouds.rackspace.account-id", ImmutableSet.of(accountID));
        }
    }
}

