/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.cloudloadbalancers.domain.LoadBalancerAttributes;
import org.jclouds.cloudloadbalancers.domain.LoadBalancerRequest;
import org.jclouds.cloudloadbalancers.functions.UnwrapLoadBalancer;
import org.jclouds.cloudloadbalancers.functions.UnwrapLoadBalancers;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@SkipEncoding(value={47})
@RequestFilters(value={AuthenticateRequest.class})
public interface LoadBalancerAsyncClient {
    @POST
    @ResponseParser(value=UnwrapLoadBalancer.class)
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/loadbalancers")
    public ListenableFuture<LoadBalancer> createLoadBalancer(@WrapWith(value="loadBalancer") LoadBalancerRequest var1);

    @PUT
    @ResponseParser(value=UnwrapLoadBalancer.class)
    @Consumes(value={"application/json"})
    @Path(value="/loadbalancers/{id}")
    public ListenableFuture<Void> updateLoadBalancerAttributes(@PathParam(value="id") int var1, @WrapWith(value="loadBalancer") LoadBalancerAttributes var2);

    @GET
    @ResponseParser(value=UnwrapLoadBalancers.class)
    @Consumes(value={"application/json"})
    @Path(value="/loadbalancers")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<LoadBalancer>> listLoadBalancers();

    @GET
    @ResponseParser(value=UnwrapLoadBalancer.class)
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}")
    public ListenableFuture<LoadBalancer> getLoadBalancer(@PathParam(value="id") int var1);

    @DELETE
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}")
    @Consumes(value={"*/*"})
    public ListenableFuture<Void> removeLoadBalancer(@PathParam(value="id") int var1);
}

