/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudservers.domain.BackupSchedule;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.binders.BindToJsonPayload;

@Singleton
public class BindBackupScheduleToJsonPayload
extends BindToJsonPayload {
    @Inject
    public BindBackupScheduleToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        throw new IllegalStateException("Replace Backup Schedule needs an BackupSchedule object, not a Map");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        Preconditions.checkArgument(toBind instanceof BackupSchedule, "this binder is only valid for BackupSchedules!");
        return super.bindToRequest(request, ImmutableMap.of("backupSchedule", toBind));
    }
}

