/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersAsyncClient;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToImage;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToOperatingSystem;
import org.jclouds.cloudservers.compute.functions.FlavorToHardware;
import org.jclouds.cloudservers.compute.functions.ServerToNodeMetadata;
import org.jclouds.cloudservers.compute.strategy.CloudServersComputeServiceAdapter;
import org.jclouds.cloudservers.domain.Flavor;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.location.suppliers.OnlyLocationOrFirstZone;

public class CloudServersComputeServiceContextModule
extends ComputeServiceAdapterContextModule<CloudServersClient, CloudServersAsyncClient, Server, Flavor, Image, Location> {
    @VisibleForTesting
    public static final Map<ServerStatus, NodeState> serverToNodeState = ImmutableMap.builder().put(ServerStatus.ACTIVE, NodeState.RUNNING).put(ServerStatus.SUSPENDED, NodeState.SUSPENDED).put(ServerStatus.DELETED, NodeState.TERMINATED).put(ServerStatus.QUEUE_RESIZE, NodeState.PENDING).put(ServerStatus.PREP_RESIZE, NodeState.PENDING).put(ServerStatus.RESIZE, NodeState.PENDING).put(ServerStatus.VERIFY_RESIZE, NodeState.PENDING).put(ServerStatus.QUEUE_MOVE, NodeState.PENDING).put(ServerStatus.PREP_MOVE, NodeState.PENDING).put(ServerStatus.MOVE, NodeState.PENDING).put(ServerStatus.VERIFY_MOVE, NodeState.PENDING).put(ServerStatus.RESCUE, NodeState.PENDING).put(ServerStatus.ERROR, NodeState.ERROR).put(ServerStatus.BUILD, NodeState.PENDING).put(ServerStatus.RESTORING, NodeState.PENDING).put(ServerStatus.PASSWORD, NodeState.PENDING).put(ServerStatus.REBUILD, NodeState.PENDING).put(ServerStatus.DELETE_IP, NodeState.PENDING).put(ServerStatus.SHARE_IP_NO_CONFIG, NodeState.PENDING).put(ServerStatus.SHARE_IP, NodeState.PENDING).put(ServerStatus.REBOOT, NodeState.PENDING).put(ServerStatus.HARD_REBOOT, NodeState.PENDING).put(ServerStatus.UNKNOWN, NodeState.UNRECOGNIZED).put(ServerStatus.UNRECOGNIZED, NodeState.UNRECOGNIZED).build();

    public CloudServersComputeServiceContextModule() {
        super(CloudServersClient.class, CloudServersAsyncClient.class);
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<Server, Flavor, Image, Location>>(){}).to(CloudServersComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(CloudServersImageToImage.class);
        this.bind(new TypeLiteral<Function<Image, OperatingSystem>>(){}).to(CloudServersImageToOperatingSystem.class);
        this.bind(new TypeLiteral<Function<Flavor, Hardware>>(){}).to(FlavorToHardware.class);
        this.bind(new TypeLiteral<Function<Location, Location>>(){}).to(IdentityFunction.class);
        this.bind(new TypeLiteral<Supplier<Location>>(){}).to(OnlyLocationOrFirstZone.class);
    }

    @Singleton
    @Provides
    Map<ServerStatus, NodeState> provideServerToNodeState() {
        return serverToNodeState;
    }
}

