/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;

@Singleton
public class ServerToNodeMetadata
implements Function<Server, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Supplier<Location> location;
    protected final Map<ServerStatus, NodeState> serverToNodeState;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;

    @Inject
    ServerToNodeMetadata(Map<ServerStatus, NodeState> serverStateToNodeState, @Memoized Supplier<Set<? extends Image>> images, Supplier<Location> location, @Memoized Supplier<Set<? extends Hardware>> hardwares) {
        this.serverToNodeState = Preconditions.checkNotNull(serverStateToNodeState, "serverStateToNodeState");
        this.images = Preconditions.checkNotNull(images, "images");
        this.location = Preconditions.checkNotNull(location, "location");
        this.hardwares = Preconditions.checkNotNull(hardwares, "hardwares");
    }

    @Override
    public NodeMetadata apply(Server from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getName());
        builder.hostname(from.getName());
        builder.location(new LocationBuilder().scope(LocationScope.HOST).id(from.getHostId()).description(from.getHostId()).parent(this.location.get()).build());
        builder.userMetadata((Map)from.getMetadata());
        builder.group(ComputeServiceUtils.parseGroupFromName(from.getName()));
        builder.imageId(from.getImageId() + "");
        builder.operatingSystem(this.parseOperatingSystem(from));
        builder.hardware(this.parseHardware(from));
        builder.state(this.serverToNodeState.get((Object)from.getStatus()));
        builder.publicAddresses(from.getAddresses().getPublicAddresses());
        builder.privateAddresses(from.getAddresses().getPrivateAddresses());
        return builder.build();
    }

    protected Hardware parseHardware(Server from) {
        try {
            return Iterables.find((Iterable)this.hardwares.get(), new FindHardwareForServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching hardware for server %s", from);
            return null;
        }
    }

    protected OperatingSystem parseOperatingSystem(Server from) {
        try {
            return Iterables.find((Iterable)this.images.get(), new FindImageForServer(from)).getOperatingSystem();
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching image for server %s in location %s", from, this.location);
            return null;
        }
    }

    private static class FindHardwareForServer
    implements Predicate<Hardware> {
        private final Server instance;

        private FindHardwareForServer(Server instance) {
            this.instance = instance;
        }

        @Override
        public boolean apply(Hardware input) {
            return input.getProviderId().equals(this.instance.getFlavorId() + "");
        }
    }

    private static class FindImageForServer
    implements Predicate<Image> {
        private final Server instance;

        private FindImageForServer(Server instance) {
            this.instance = instance;
        }

        @Override
        public boolean apply(Image input) {
            return input.getProviderId().equals(this.instance.getImageId() + "");
        }
    }
}

