/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.config;

import com.google.inject.Provides;
import java.net.URI;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersAsyncClient;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.ServerManagement;
import org.jclouds.cloudservers.handlers.ParseCloudServersErrorFromHttpResponse;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.OpenStackAuthAsyncClient;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.handlers.RetryOnRenew;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
@RequiresHttp
public class CloudServersRestClientModule
extends RestClientModule<CloudServersClient, CloudServersAsyncClient> {
    private final OpenStackAuthenticationModule module;

    public CloudServersRestClientModule(OpenStackAuthenticationModule module) {
        super(CloudServersClient.class, CloudServersAsyncClient.class);
        this.module = module;
    }

    public CloudServersRestClientModule() {
        this(new OpenStackAuthenticationModule());
    }

    @Override
    protected void configure() {
        this.install(this.module);
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseCloudServersErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseCloudServersErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseCloudServersErrorFromHttpResponse.class);
    }

    @Override
    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
    }

    @Provides
    @Singleton
    @ServerManagement
    protected URI provideServerUrl(OpenStackAuthAsyncClient.AuthenticationResponse response) {
        return response.getServices().get("X-Server-Management-Url");
    }
}

