/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.util.ComputeServiceUtils;

@Singleton
public class ParseOsFamilyVersion64BitFromImageName
implements Function<String, OsFamilyVersion64Bit> {
    private final Map<OsFamily, Map<String, String>> osVersionMap;
    public static final Pattern PATTERN = Pattern.compile("([^ -]+)[^0-9]([0-9.]+)[ -].*");

    @Inject
    public ParseOsFamilyVersion64BitFromImageName(Map<OsFamily, Map<String, String>> osVersionMap) {
        this.osVersionMap = osVersionMap;
    }

    @Override
    public OsFamilyVersion64Bit apply(String input) {
        boolean is64Bit = Predicates.and(Predicates.not(Predicates.containsPattern("32bit")), Predicates.or(Predicates.containsPattern("64bit"), Predicates.not(Predicates.containsPattern("Windows")))).apply(input);
        if (input.contains("Windows")) {
            String version = null;
            Matcher matcher = Pattern.compile(".*(20[01][0-9] R[1-9]).*").matcher(input);
            if (matcher.find()) {
                version = matcher.group(1);
            } else {
                matcher = Pattern.compile(".*(20[01][0-9]).*").matcher(input);
                if (matcher.find()) {
                    version = matcher.group(1);
                }
            }
            return new OsFamilyVersion64Bit(OsFamily.WINDOWS, this.osVersionMap.get((Object)OsFamily.WINDOWS).get(version), is64Bit);
        }
        Matcher matcher = PATTERN.matcher(input);
        if (matcher.find()) {
            OsFamily fam = OsFamily.fromValue(matcher.group(1).toLowerCase());
            switch (fam) {
                case UNRECOGNIZED: {
                    return new OsFamilyVersion64Bit(OsFamily.UNRECOGNIZED, null, is64Bit);
                }
            }
            return new OsFamilyVersion64Bit(fam, ComputeServiceUtils.parseVersionOrReturnEmptyString(fam, matcher.group(2), this.osVersionMap), is64Bit);
        }
        return new OsFamilyVersion64Bit(OsFamily.UNRECOGNIZED, null, is64Bit);
    }
}

