/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.DriveMetrics;

@Singleton
public class MapToDriveMetrics
implements Function<Map<String, String>, Map<String, ? extends DriveMetrics>> {
    @Override
    public Map<String, ? extends DriveMetrics> apply(Map<String, String> from) {
        ImmutableMap.Builder<String, DriveMetrics> builder = ImmutableMap.builder();
        this.addIDEDevices(from, builder);
        this.addSCSIDevices(from, builder);
        this.addBlockDevices(from, builder);
        return builder.build();
    }

    protected void addBlockDevices(Map<String, String> from, ImmutableMap.Builder<String, DriveMetrics> devices) {
        for (int index : new int[]{0, 1, 2, 3, 4, 5, 6, 7}) {
            String key = String.format("block:0:%d", index);
            if (!from.containsKey(key)) break;
            devices.put(key, this.buildMetrics(key, from));
        }
    }

    protected void addSCSIDevices(Map<String, String> from, ImmutableMap.Builder<String, DriveMetrics> devices) {
        for (int unit : new int[]{0, 1, 2, 3, 4, 5, 6, 7}) {
            String key = String.format("scsi:0:%d", unit);
            if (!from.containsKey(key)) break;
            devices.put(key, this.buildMetrics(key, from));
        }
    }

    protected void addIDEDevices(Map<String, String> from, ImmutableMap.Builder<String, DriveMetrics> devices) {
        block0: for (int bus : new int[]{0, 1}) {
            for (int unit : new int[]{0, 1}) {
                String key = String.format("ide:%d:%d", bus, unit);
                if (!from.containsKey(key)) break block0;
                devices.put(key, this.buildMetrics(key, from));
            }
        }
    }

    protected DriveMetrics buildMetrics(String key, Map<String, String> from) {
        DriveMetrics.Builder builder = new DriveMetrics.Builder();
        if (from.containsKey(key + ":read:bytes")) {
            builder.readBytes(new Long(from.get(key + ":read:bytes")));
        }
        if (from.containsKey(key + ":read:requests")) {
            builder.readRequests(new Long(from.get(key + ":read:requests")));
        }
        if (from.containsKey(key + ":write:bytes")) {
            builder.writeBytes(new Long(from.get(key + ":write:bytes")));
        }
        if (from.containsKey(key + ":write:requests")) {
            builder.writeRequests(new Long(from.get(key + ":write:requests")));
        }
        return builder.build();
    }
}

