/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindCIDRsToCommaDelimitedQueryParam
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public BindCIDRsToCommaDelimitedQueryParam(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = Preconditions.checkNotNull(uriBuilderProvider, "uriBuilderProvider");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof Iterable, "this binder is only valid for Iterables!");
        Iterable cidrs = (Iterable)Preconditions.checkNotNull(input, "cidr list");
        Preconditions.checkArgument(Iterables.size(cidrs) > 0, "you must specify at least one cidr range");
        return ModifyRequest.addQueryParam(request, "cidrlist", Joiner.on(',').join(cidrs), this.uriBuilderProvider.get());
    }
}

