/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindIdListToCommaDelimitedQueryParam
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public BindIdListToCommaDelimitedQueryParam(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = Preconditions.checkNotNull(uriBuilderProvider, "uriBuilderProvider");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof Iterable, "this binder is only valid for Iterables!");
        Iterable numbers = (Iterable)Preconditions.checkNotNull(input, "list of Longs");
        Preconditions.checkArgument(Iterables.size(numbers) > 0, "you must specify at least one element");
        return ModifyRequest.addQueryParam(request, "ids", Joiner.on(',').join(numbers), this.uriBuilderProvider.get());
    }
}

