/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.cloudstack.domain.TemplateMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class BindTemplateMetadataToQueryParams
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public BindTemplateMetadataToQueryParams(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = Preconditions.checkNotNull(uriBuilderProvider, "uriBuilderProvider");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof TemplateMetadata, "this binder is only valid for TemplateMetadata");
        TemplateMetadata metadata = (TemplateMetadata)input;
        request = ModifyRequest.addQueryParam(request, "name", metadata.getName(), this.uriBuilderProvider.get());
        request = ModifyRequest.addQueryParam(request, "ostypeid", metadata.getOsTypeId(), this.uriBuilderProvider.get());
        request = ModifyRequest.addQueryParam(request, "displaytext", metadata.getDisplayText(), this.uriBuilderProvider.get());
        if (metadata.getSnapshotId() != null) {
            request = ModifyRequest.addQueryParam(request, "snapshotid", metadata.getSnapshotId(), this.uriBuilderProvider.get());
        }
        if (metadata.getVolumeId() != null) {
            request = ModifyRequest.addQueryParam(request, "volumeid", metadata.getVolumeId(), this.uriBuilderProvider.get());
        }
        if (metadata.getVirtualMachineId() != null) {
            request = ModifyRequest.addQueryParam(request, "virtualmachineid", metadata.getVirtualMachineId(), this.uriBuilderProvider.get());
        }
        if (metadata.getPasswordEnabled() != null) {
            request = ModifyRequest.addQueryParam(request, "passwordenabled", metadata.getPasswordEnabled(), this.uriBuilderProvider.get());
        }
        return request;
    }
}

