/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.cloudstack.domain.ResourceLimit;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class ResourceLimitToQueryParams
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public ResourceLimitToQueryParams(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = Preconditions.checkNotNull(uriBuilderProvider, "uriBuilderProvider");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof ResourceLimit, "this binder is only valid for ResourceLimit");
        ResourceLimit limit = (ResourceLimit)input;
        request = ModifyRequest.addQueryParam(request, "resourcetype", limit.getResourceType().getCode(), this.uriBuilderProvider.get());
        request = ModifyRequest.addQueryParam(request, "account", limit.getAccount(), this.uriBuilderProvider.get());
        request = ModifyRequest.addQueryParam(request, "domainid", limit.getDomainId(), this.uriBuilderProvider.get());
        request = ModifyRequest.addQueryParam(request, "max", limit.getMax(), this.uriBuilderProvider.get());
        return request;
    }
}

