/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.collect.FindResourceInSet;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.InetAddresses2;
import org.jclouds.util.Throwables2;

@Singleton
public class VirtualMachineToNodeMetadata
implements Function<VirtualMachine, NodeMetadata> {
    public static final Map<VirtualMachine.State, NodeState> vmStateToNodeState = ImmutableMap.builder().put(VirtualMachine.State.STARTING, NodeState.PENDING).put(VirtualMachine.State.RUNNING, NodeState.RUNNING).put(VirtualMachine.State.STOPPING, NodeState.PENDING).put(VirtualMachine.State.STOPPED, NodeState.SUSPENDED).put(VirtualMachine.State.DESTROYED, NodeState.TERMINATED).put(VirtualMachine.State.EXPUNGING, NodeState.TERMINATED).put(VirtualMachine.State.MIGRATING, NodeState.PENDING).put(VirtualMachine.State.ERROR, NodeState.ERROR).put(VirtualMachine.State.UNKNOWN, NodeState.UNRECOGNIZED).put(VirtualMachine.State.SHUTDOWNED, NodeState.PENDING).put(VirtualMachine.State.UNRECOGNIZED, NodeState.UNRECOGNIZED).build();
    private final FindLocationForVirtualMachine findLocationForVirtualMachine;
    private final FindHardwareForVirtualMachine findHardwareForVirtualMachine;
    private final FindImageForVirtualMachine findImageForVirtualMachine;
    private final LoadingCache<Long, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine;

    @Inject
    VirtualMachineToNodeMetadata(FindLocationForVirtualMachine findLocationForVirtualMachine, FindHardwareForVirtualMachine findHardwareForVirtualMachine, FindImageForVirtualMachine findImageForVirtualMachine, LoadingCache<Long, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine) {
        this.findLocationForVirtualMachine = Preconditions.checkNotNull(findLocationForVirtualMachine, "findLocationForVirtualMachine");
        this.findHardwareForVirtualMachine = Preconditions.checkNotNull(findHardwareForVirtualMachine, "findHardwareForVirtualMachine");
        this.findImageForVirtualMachine = Preconditions.checkNotNull(findImageForVirtualMachine, "findImageForVirtualMachine");
        this.getIPForwardingRulesByVirtualMachine = Preconditions.checkNotNull(getIPForwardingRulesByVirtualMachine, "getIPForwardingRulesByVirtualMachine");
    }

    @Override
    public NodeMetadata apply(VirtualMachine from) {
        NodeMetadataBuilder builder;
        block7: {
            Hardware hardware;
            builder = new NodeMetadataBuilder();
            builder.ids(from.getId() + "");
            builder.name(from.getName());
            builder.hostname(from.getDisplayName());
            builder.location((Location)this.findLocationForVirtualMachine.apply(from));
            builder.group(ComputeServiceUtils.parseGroupFromName(from.getDisplayName()));
            Image image = (Image)this.findImageForVirtualMachine.apply(from);
            if (image != null) {
                builder.imageId(image.getId());
                builder.operatingSystem(image.getOperatingSystem());
            }
            if ((hardware = (Hardware)this.findHardwareForVirtualMachine.apply(from)) != null) {
                builder.hardware(hardware);
            }
            builder.state(vmStateToNodeState.get((Object)from.getState()));
            if (from.getIPAddress() != null) {
                boolean isPrivate = InetAddresses2.isPrivateIPAddress(from.getIPAddress());
                ImmutableSet<String> addresses = ImmutableSet.of(from.getIPAddress());
                if (isPrivate) {
                    builder.privateAddresses(addresses);
                } else {
                    builder.publicAddresses(addresses);
                }
            }
            try {
                builder.publicAddresses(Iterables.transform(Iterables.filter((Iterable)this.getIPForwardingRulesByVirtualMachine.getUnchecked(from.getId()), new Predicate<IPForwardingRule>(){

                    @Override
                    public boolean apply(@Nullable IPForwardingRule rule) {
                        return !"Deleting".equals(rule.getState());
                    }
                }), new Function<IPForwardingRule, String>(){

                    @Override
                    public String apply(@Nullable IPForwardingRule rule) {
                        return rule.getIPAddress();
                    }
                }));
            }
            catch (UncheckedExecutionException e) {
                if (Throwables2.getFirstThrowableOfType(e, ResourceNotFoundException.class) != null) break block7;
                Throwables.propagateIfPossible(e.getCause());
                throw e;
            }
        }
        return builder.build();
    }

    @Singleton
    public static class FindImageForVirtualMachine
    extends FindResourceInSet<VirtualMachine, Image> {
        @Inject
        public FindImageForVirtualMachine(@Memoized Supplier<Set<? extends Image>> location) {
            super(location);
        }

        @Override
        public boolean matches(VirtualMachine from, Image input) {
            return input.getProviderId().equals(from.getTemplateId() + "") && (input.getLocation() == null || input.getId().equals(from.getZoneId() + ""));
        }
    }

    @Singleton
    public static class FindHardwareForVirtualMachine
    extends FindResourceInSet<VirtualMachine, Hardware> {
        @Inject
        public FindHardwareForVirtualMachine(@Memoized Supplier<Set<? extends Hardware>> location) {
            super(location);
        }

        @Override
        public boolean matches(VirtualMachine from, Hardware input) {
            return input.getProviderId().equals(Long.toString(from.getServiceOfferingId()));
        }
    }

    @Singleton
    public static class FindLocationForVirtualMachine
    extends FindResourceInSet<VirtualMachine, Location> {
        @Inject
        public FindLocationForVirtualMachine(@Memoized Supplier<Set<? extends Location>> location) {
            super(location);
        }

        @Override
        public boolean matches(VirtualMachine from, Location input) {
            return input.getId().equals(Long.toString(from.getZoneId()));
        }
    }
}

