/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.OptionsConverter;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.functions.CreatePortForwardingRulesForIP;
import org.jclouds.cloudstack.functions.StaticNATVirtualMachineInNetwork;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.jclouds.cloudstack.options.ListServiceOfferingsOptions;
import org.jclouds.cloudstack.options.ListVirtualMachinesOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.cloudstack.predicates.TemplatePredicates;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

@Singleton
public class CloudStackComputeServiceAdapter
implements ComputeServiceAdapter<VirtualMachine, ServiceOffering, Template, Zone> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudStackClient client;
    private final Predicate<Long> jobComplete;
    private final Supplier<Map<Long, Network>> networkSupplier;
    private final BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult;
    private final StaticNATVirtualMachineInNetwork.Factory staticNATVMInNetwork;
    private final CreatePortForwardingRulesForIP setupPortForwardingRulesForIP;
    private final LoadingCache<Long, Set<IPForwardingRule>> vmToRules;
    private final Map<String, Credentials> credentialStore;
    private final Map<NetworkType, ? extends OptionsConverter> optionsConverters;
    private final Supplier<LoadingCache<Long, Zone>> zoneIdToZone;

    @Inject
    public CloudStackComputeServiceAdapter(CloudStackClient client, Predicate<Long> jobComplete, @Memoized Supplier<Map<Long, Network>> networkSupplier, BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult, StaticNATVirtualMachineInNetwork.Factory staticNATVMInNetwork, CreatePortForwardingRulesForIP setupPortForwardingRulesForIP, LoadingCache<Long, Set<IPForwardingRule>> vmToRules, Map<String, Credentials> credentialStore, Map<NetworkType, ? extends OptionsConverter> optionsConverters, Supplier<LoadingCache<Long, Zone>> zoneIdToZone) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.jobComplete = Preconditions.checkNotNull(jobComplete, "jobComplete");
        this.networkSupplier = Preconditions.checkNotNull(networkSupplier, "networkSupplier");
        this.blockUntilJobCompletesAndReturnResult = Preconditions.checkNotNull(blockUntilJobCompletesAndReturnResult, "blockUntilJobCompletesAndReturnResult");
        this.staticNATVMInNetwork = Preconditions.checkNotNull(staticNATVMInNetwork, "staticNATVMInNetwork");
        this.setupPortForwardingRulesForIP = Preconditions.checkNotNull(setupPortForwardingRulesForIP, "setupPortForwardingRulesForIP");
        this.vmToRules = Preconditions.checkNotNull(vmToRules, "vmToRules");
        this.credentialStore = Preconditions.checkNotNull(credentialStore, "credentialStore");
        this.optionsConverters = optionsConverters;
        this.zoneIdToZone = zoneIdToZone;
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<VirtualMachine> createNodeWithGroupEncodedIntoName(String group, String name, org.jclouds.compute.domain.Template template) {
        Preconditions.checkNotNull(template, "template was null");
        Preconditions.checkNotNull(template.getOptions(), "template options was null");
        Preconditions.checkArgument(template.getOptions().getClass().isAssignableFrom(CloudStackTemplateOptions.class), "options class %s should have been assignable from CloudStackTemplateOptions", template.getOptions().getClass());
        Map<Long, Network> networks = this.networkSupplier.get();
        long zoneId = Long.parseLong(template.getLocation().getId());
        Zone zone = null;
        try {
            zone = this.zoneIdToZone.get().get(zoneId);
        }
        catch (ExecutionException e) {
            Throwables.propagate(e);
        }
        CloudStackTemplateOptions templateOptions = template.getOptions().as(CloudStackTemplateOptions.class);
        Preconditions.checkState(this.optionsConverters.containsKey((Object)zone.getNetworkType()), "no options converter configured for network type %s", new Object[]{zone.getNetworkType()});
        DeployVirtualMachineOptions options = DeployVirtualMachineOptions.Builder.displayName(name).name(name);
        OptionsConverter optionsConverter = this.optionsConverters.get((Object)zone.getNetworkType());
        options = optionsConverter.apply(templateOptions, networks, zoneId, options);
        if (templateOptions.getIpOnDefaultNetwork() != null) {
            options.ipOnDefaultNetwork(templateOptions.getIpOnDefaultNetwork());
        }
        if (templateOptions.getIpsToNetworks().size() > 0) {
            options.ipsToNetworks(templateOptions.getIpsToNetworks());
        }
        if (templateOptions.getKeyPair() != null) {
            options.keyPair(templateOptions.getKeyPair());
            if (templateOptions.getRunScript() != null) {
                Preconditions.checkArgument(this.credentialStore.containsKey("keypair#" + templateOptions.getKeyPair()), "no private key configured for: %s; please use options.overrideLoginCredentialWith(rsa_private_text)", templateOptions.getKeyPair());
            }
        }
        long templateId = Long.parseLong(template.getImage().getId());
        long serviceOfferingId = Long.parseLong(template.getHardware().getId());
        this.logger.info("serviceOfferingId %d, templateId %d, zoneId %d, options %s%n", serviceOfferingId, templateId, zoneId, options);
        AsyncCreateResponse job = this.client.getVirtualMachineClient().deployVirtualMachineInZone(zoneId, serviceOfferingId, templateId, options);
        VirtualMachine vm = (VirtualMachine)this.blockUntilJobCompletesAndReturnResult.apply(job);
        LoginCredentials credentials = null;
        if (vm.isPasswordEnabled()) {
            assert (vm.getPassword() != null) : vm;
            credentials = LoginCredentials.builder().password(vm.getPassword()).build();
        } else {
            credentials = LoginCredentials.fromCredentials(this.credentialStore.get("keypair#" + templateOptions.getKeyPair()));
        }
        if (templateOptions.shouldSetupStaticNat()) {
            for (long networkId : options.getNetworkIds()) {
                this.logger.debug(">> creating static NAT for virtualMachine(%s) in network(%s)", vm.getId(), networkId);
                PublicIPAddress ip = this.staticNATVMInNetwork.create(networks.get(networkId)).apply(vm);
                this.logger.trace("<< static NATed IPAddress(%s) to virtualMachine(%s)", ip.getId(), vm.getId());
                List<Integer> ports = Ints.asList(templateOptions.getInboundPorts());
                this.logger.debug(">> setting up IP forwarding for IPAddress(%s) rules(%s)", ip.getId(), ports);
                Set<IPForwardingRule> rules = this.setupPortForwardingRulesForIP.apply(ip, ports);
                this.logger.trace("<< setup %d IP forwarding rules on IPAddress(%s)", rules.size(), ip.getId());
            }
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials<VirtualMachine>(vm, vm.getId() + "", credentials);
    }

    @Override
    public Iterable<ServiceOffering> listHardwareProfiles() {
        return this.client.getOfferingClient().listServiceOfferings(new ListServiceOfferingsOptions[0]);
    }

    @Override
    public Iterable<Template> listImages() {
        return Iterables.filter(this.client.getTemplateClient().listTemplates(), TemplatePredicates.isReady());
    }

    @Override
    public Iterable<VirtualMachine> listNodes() {
        return this.client.getVirtualMachineClient().listVirtualMachines(new ListVirtualMachinesOptions[0]);
    }

    @Override
    public Iterable<Zone> listLocations() {
        return this.client.getZoneClient().listZones(new ListZonesOptions[0]);
    }

    @Override
    public VirtualMachine getNode(String id) {
        long virtualMachineId = Long.parseLong(id);
        return this.client.getVirtualMachineClient().getVirtualMachine(virtualMachineId);
    }

    @Override
    public void destroyNode(String id) {
        long virtualMachineId = Long.parseLong(id);
        Set<Long> ipAddresses = this.deleteIPForwardingRulesForVMAndReturnDistinctIPs(virtualMachineId);
        this.disableStaticNATOnIPAddresses(ipAddresses);
        this.disassociateIPAddresses(ipAddresses);
        this.destroyVirtualMachine(virtualMachineId);
        this.vmToRules.invalidate(virtualMachineId);
    }

    public void disassociateIPAddresses(Set<Long> ipAddresses) {
        for (long ipAddress : ipAddresses) {
            this.logger.debug(">> disassociating IPAddress(%s)", ipAddress);
            this.client.getAddressClient().disassociateIPAddress(ipAddress);
        }
    }

    public void destroyVirtualMachine(long virtualMachineId) {
        Long destroyVirtualMachine = this.client.getVirtualMachineClient().destroyVirtualMachine(virtualMachineId);
        if (destroyVirtualMachine != null) {
            this.logger.debug(">> destroying virtualMachine(%s) job(%s)", virtualMachineId, destroyVirtualMachine);
            this.awaitCompletion(destroyVirtualMachine);
        } else {
            this.logger.trace("<< virtualMachine(%s) not found", virtualMachineId);
        }
    }

    public void disableStaticNATOnIPAddresses(Set<Long> ipAddresses) {
        ImmutableSet.Builder jobsToTrack = ImmutableSet.builder();
        for (Long ipAddress : ipAddresses) {
            Long disableStaticNAT = this.client.getNATClient().disableStaticNATOnPublicIP(ipAddress);
            if (disableStaticNAT == null) continue;
            this.logger.debug(">> disabling static NAT IPAddress(%s) job(%s)", ipAddress, disableStaticNAT);
            jobsToTrack.add(disableStaticNAT);
        }
        this.awaitCompletion(jobsToTrack.build());
    }

    public Set<Long> deleteIPForwardingRulesForVMAndReturnDistinctIPs(long virtualMachineId) {
        ImmutableSet.Builder jobsToTrack = ImmutableSet.builder();
        LinkedHashSet<Long> ipAddresses = Sets.newLinkedHashSet();
        Set<IPForwardingRule> forwardingRules = this.client.getNATClient().getIPForwardingRulesForVirtualMachine(virtualMachineId);
        for (IPForwardingRule rule : forwardingRules) {
            if ("Deleting".equals(rule.getState())) continue;
            ipAddresses.add(rule.getIPAddressId());
            Long deleteForwardingRule = this.client.getNATClient().deleteIPForwardingRule(rule.getId());
            if (deleteForwardingRule == null) continue;
            this.logger.debug(">> deleting IPForwardingRule(%s) job(%s)", rule.getId(), deleteForwardingRule);
            jobsToTrack.add(deleteForwardingRule);
        }
        this.awaitCompletion(jobsToTrack.build());
        return ipAddresses;
    }

    public void awaitCompletion(Iterable<Long> jobs) {
        this.logger.debug(">> awaiting completion of jobs(%s)", jobs);
        for (long job : jobs) {
            this.awaitCompletion(job);
        }
        this.logger.trace("<< completed jobs(%s)", jobs);
    }

    public void awaitCompletion(long job) {
        boolean completed = this.jobComplete.apply(job);
        this.logger.trace("<< job(%s) complete(%s)", job, completed);
    }

    @Override
    public void rebootNode(String id) {
        long virtualMachineId = Long.parseLong(id);
        Long job = this.client.getVirtualMachineClient().rebootVirtualMachine(virtualMachineId);
        if (job != null) {
            this.logger.debug(">> rebooting virtualMachine(%s) job(%s)", virtualMachineId, job);
            this.awaitCompletion(job);
        }
    }

    @Override
    public void resumeNode(String id) {
        long virtualMachineId = Long.parseLong(id);
        Long job = this.client.getVirtualMachineClient().startVirtualMachine(Long.parseLong(id));
        if (job != null) {
            this.logger.debug(">> starting virtualMachine(%s) job(%s)", virtualMachineId, job);
            this.awaitCompletion(job);
        }
    }

    @Override
    public void suspendNode(String id) {
        long virtualMachineId = Long.parseLong(id);
        Long job = this.client.getVirtualMachineClient().stopVirtualMachine(Long.parseLong(id));
        if (job != null) {
            this.logger.debug(">> stopping virtualMachine(%s) job(%s)", virtualMachineId, job);
            this.awaitCompletion(job);
        }
    }
}

