/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;

public class Capabilities {
    @SerializedName(value="cloudstackversion")
    private String cloudStackVersion;
    @SerializedName(value="securitygroupsenabled")
    private boolean securityGroupsEnabled;
    @SerializedName(value="userpublictemplateenabled")
    private boolean canShareTemplates;
    private boolean firewallRuleUiEnabled;
    private boolean supportELB;

    public static Builder builder() {
        return new Builder();
    }

    Capabilities() {
    }

    public Capabilities(String cloudStackVersion, boolean securityGroupsEnabled, boolean canShareTemplates, boolean firewallRuleUiEnabled, boolean supportELB) {
        this.cloudStackVersion = cloudStackVersion;
        this.securityGroupsEnabled = securityGroupsEnabled;
        this.canShareTemplates = canShareTemplates;
        this.firewallRuleUiEnabled = firewallRuleUiEnabled;
        this.supportELB = supportELB;
    }

    public String getCloudStackVersion() {
        return this.cloudStackVersion;
    }

    public boolean isSecurityGroupsEnabled() {
        return this.securityGroupsEnabled;
    }

    public boolean isSharedTemplatesEnabled() {
        return this.canShareTemplates;
    }

    public boolean isFirewallRuleUiEnabled() {
        return this.firewallRuleUiEnabled;
    }

    public boolean isSupportELB() {
        return this.supportELB;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canShareTemplates ? 1231 : 1237);
        result = 31 * result + (this.cloudStackVersion == null ? 0 : this.cloudStackVersion.hashCode());
        result = 31 * result + (this.securityGroupsEnabled ? 1231 : 1237);
        result = 31 * result + (this.firewallRuleUiEnabled ? 1231 : 1237);
        result = 31 * result + (this.supportELB ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Capabilities other = (Capabilities)obj;
        if (this.canShareTemplates != other.canShareTemplates) {
            return false;
        }
        if (this.cloudStackVersion == null ? other.cloudStackVersion != null : !this.cloudStackVersion.equals(other.cloudStackVersion)) {
            return false;
        }
        if (this.securityGroupsEnabled != other.securityGroupsEnabled) {
            return false;
        }
        if (this.firewallRuleUiEnabled != other.firewallRuleUiEnabled) {
            return false;
        }
        return this.supportELB == other.supportELB;
    }

    public String toString() {
        return "Capabilities{cloudStackVersion='" + this.cloudStackVersion + '\'' + ", securityGroupsEnabled=" + this.securityGroupsEnabled + ", canShareTemplates=" + this.canShareTemplates + ", firewallRuleUiEnabled=" + this.firewallRuleUiEnabled + ", supportELB=" + this.supportELB + '}';
    }

    public static class Builder {
        private String cloudStackVersion;
        private boolean securityGroupsEnabled;
        private boolean canShareTemplates;
        private boolean firewallRuleUiEnabled;
        private boolean supportELB;

        public Builder cloudStackVersion(String cloudStackVersion) {
            this.cloudStackVersion = cloudStackVersion;
            return this;
        }

        public Builder securityGroupsEnabled(boolean securityGroupsEnabled) {
            this.securityGroupsEnabled = securityGroupsEnabled;
            return this;
        }

        public Builder sharedTemplatesEnabled(boolean canShareTemplates) {
            this.canShareTemplates = canShareTemplates;
            return this;
        }

        public Builder firewallRuleUiEnabled(boolean firewallRuleUiEnabled) {
            this.firewallRuleUiEnabled = firewallRuleUiEnabled;
            return this;
        }

        public Builder supportELB(boolean supportELB) {
            this.supportELB = supportELB;
            return this;
        }

        public Capabilities build() {
            return new Capabilities(this.cloudStackVersion, this.securityGroupsEnabled, this.canShareTemplates, this.firewallRuleUiEnabled, this.supportELB);
        }
    }
}

